package tivonage;

import com.tivo.hme.bananas.BView;

/**
 * Provides the "I'm thinking" spinner of indeterminate duration.
 * 
 * @author <a href="http://www.martiansoftware.com/contact.html">Marty Lamb</a>
 */
public class Spinner extends BView {

	private int index = -1;
	private boolean running;
	private boolean succeeded;
	private static final String[] FRAMES = { "busy-0.gif", "busy-1.gif", "busy-2.gif" };
	private boolean silent = false;
	
	public static final long FRAME_DELAY = 700	;
	public Spinner(BView parent, int x, int y, int width, int height) {
		super(parent, x, y, width, height);
		init();
	}

	public Spinner(BView parent, int x, int y, int width, int height, boolean visible) {
		super(parent, x, y, width, height, visible);
		init();
	}

	private void init() {
		running = true;
		succeeded = false;
		TiVonage.timer.schedule(new SpinnerTimerTask(this), FRAME_DELAY);
	}
	
	/**
	 * If silent, this is not a machine that goes "bing"
	 * @param silent
	 */
	public void setSilent(boolean silent) {
		this.silent = silent;
	}
	
	private void nextImage() {
		++index;
		index %= FRAMES.length;
		this.setResource(FRAMES[index]);
		this.flush();
	}
	
	public void stop(boolean succeeded) {
		running = false;
		this.succeeded = succeeded;
	}
	
	public boolean isRunning() {
		return (running);
	}
	
	private class SpinnerTimerTask extends java.util.TimerTask {
		
		private Spinner spinner;
		
		SpinnerTimerTask(Spinner spinner) {
			this.spinner = spinner;
		}
		
		public void run() {
			if (spinner.isRunning()) {
				spinner.nextImage();
				TiVonage.timer.schedule(new SpinnerTimerTask(spinner), Spinner.FRAME_DELAY);
			} else {
				spinner.setResource(null);
				if (!spinner.silent) {
					if (spinner.succeeded) {
						spinner.play("thumbsup.snd");
					} else {
						spinner.play("thumbsdown.snd");
					}
					spinner.flush();
				}
			}
		}
	}

}
