package tivonage;

import java.io.File;
import java.text.SimpleDateFormat;

import com.mutchek.vonaje.Message;
import com.mutchek.vonaje.PhoneNumber;

import com.tivo.hme.bananas.BApplication;
import com.tivo.hme.bananas.BText;
import com.tivo.hme.bananas.BView;

/**
 * The message playback screen
 *  
 * @author <a href="http://www.martiansoftware.com/contact.html">Marty Lamb</a>
 */
public class PlayScreen extends basescreens.BaseScreen implements com.mutchek.vonaje.ProgressHandler, Runnable {

	private Step stepConverting;
	private Step stepDownloading;

	private Message message;
	private PlayBar playbar;
	private BText ms, messageDesc, md;
	private SimpleDateFormat day;
	private SimpleDateFormat time;
	private java.text.DecimalFormat seconds;

	public PlayScreen(BApplication app) {
		super(app);
		setTitle("Play Message");
		setBackground("blue.jpg");
		stepDownloading = new Step(normal, SAFE_TITLE_H + 10, SAFE_TITLE_V + 220, SCREEN_WIDTH, 36, "Downloading", "(approx 5 sec)");
		stepConverting = new Step(normal, SAFE_TITLE_H + 10, SAFE_TITLE_V + 220 + 40, SCREEN_WIDTH, 36, "Converting", "(approx 2 sec)");
		day = new SimpleDateFormat("EEE M/d");
		time = new SimpleDateFormat("h:mm a");
		seconds = new java.text.DecimalFormat("00");

    	ms = new BText(this.normal, SAFE_TITLE_H + 10, SAFE_TITLE_V + 90, SCREEN_WIDTH, 48);
		ms.setFont("default-36.font");
		ms.setFlags(RSRC_HALIGN_LEFT);
		
		messageDesc = new BText(this.normal, SAFE_TITLE_H + 10, SAFE_TITLE_V + 140, SCREEN_WIDTH, 48 * 3);
		messageDesc.setFont("default-24.font");
		messageDesc.setFlags(RSRC_HALIGN_LEFT | RSRC_VALIGN_TOP | RSRC_TEXT_WRAP);

		md = new BText(this.normal, SCREEN_WIDTH / 2, 300, (SCREEN_WIDTH - 2 * SAFE_TITLE_H)/2, 60);
		md.setFont("default-18.font");
		md.setFlags(RSRC_HALIGN_RIGHT | RSRC_TEXT_WRAP | RSRC_VALIGN_TOP);
		
		playbar = new PlayBar(normal);
//		new Thread(this).start();
	}

	/**
	 * Receives download progress events from vonaje
	 */
	public void setProgress(float progress) {
		stepDownloading.setStatus("(" + (int) (progress * 100) + "%)");
		stepDownloading.flush();
		
		playbar.setProgress((int) (progress * message.getDuration()));
	}
	
	/**
	 * Receives download progress events from vonaje
	 */
	public void setComplete(boolean complete) {
		stepDownloading.setStatus("(Done)");
	}
	
	public boolean handleEnter(Object o, boolean isReturn) {
		new Thread(this).start();
		return (true);
	}
	
//	private void sleep(long l) {
//		try {Thread.sleep(l);} catch (Exception e) {}
//	}
	
	public boolean handleKeyPress(int code, long rawcode) {
//		System.out.println("PlayScreen keypress: " + code);
		if (playbar.handleKeyPress(code, rawcode)) return (true);
		if (code == KEY_LEFT) {
			playbar.stop();
			getBApp().pop();
		}
		return (super.handleKeyPress(code, rawcode));
	}
	
	public void setMessage(Message message) {
		this.message = message;
		playbar.setPosition(0);
		playbar.setProgress(0);
		playbar.setDuration(message.getDuration());
		
		if (message.getCallerName() == null || message.getCallerName().trim().length() == 0) {
			ms.setValue(PhoneNumber.format(message.getCallerNumber()));
			messageDesc.setValue("");
		} else {
			ms.setValue(message.getCallerName());
			messageDesc.setValue(PhoneNumber.format(message.getCallerNumber()) + "\n" + message.getCallerAddress());
		}
		md.setValue( 
				day.format(message.getCallTime()) + " " + time.format(message.getCallTime()).toLowerCase() + "\n"
				+ "Duration: " + formatDuration(message.getDuration()));
	}
	
	private String formatDuration(int durationSeconds) {
		return ((durationSeconds / 60) + ":" + seconds.format(durationSeconds % 60));
	}
	
	public void run() {
		playbar.setPaused(true);
		stepDownloading.setStatus(message.isCached() ? "(Cached)" : stepDownloading.desc);
		stepDownloading.setTransparency(0);
		stepConverting.setStatus(stepConverting.desc);
		stepConverting.setTransparency(0);

		Spinner spinner = stepDownloading.start();
		playbar.setBarColor(new java.awt.Color(192, 0, 0));
		java.io.File wavFile = null;
		try {
			wavFile = message.getMessage(this);
			playbar.setProgress(playbar.getDuration());
//			System.out.println("Got it.");
		} catch (Exception e) {
			// TODO: display message
			e.printStackTrace();
		}
		spinner.stop(true);
		flush();
		
		playbar.setBarColor(new java.awt.Color(192,192,0));
		spinner = stepConverting.start();

		String mp3Name = wavFile.getName().substring(0, wavFile.getName().length() - 3) + "mp3";
		File mp3File = new File(wavFile.getParentFile(), mp3Name);
		MP3Encoder enc = ((TiVonage) getBApp()).getMP3Encoder();
		enc.convert(TiVonage.getHomeDir(), wavFile, mp3File);
		stepConverting.setStatus("(Done)");
		spinner.stop(true);
		
//		playbar.setS
		flush();

		playbar.setBarColor(PlayBar.PROGRESSCOLOR_DEFAULT);
		playbar.setStream(getBApp().getContext().base +  message.getVonagePhoneNumber().getNumber() + "/" + mp3File.getName());
		playbar.play();
//		System.out.println(getBApp().getContext().base);
		stepDownloading.setTransparency(1, getResource("*1000"));
		stepConverting.setTransparency(1, getResource("*1000"));
		flush();
//		stepDownloading.remove(getResource("*1500"));
//		stepConverting.remove(getResource("*1500"));
//		flush();
	}
	
	private class Step extends BView {
		
		private BText statusBText;
		
		private String desc;
		private Spinner spinner;
		
		public Step(BView parent, int x, int y, int w, int h, String name, String status) {
			super (parent, x, y, w, h);
			
			BText nameBText = new BText(this, 40, 0, 150, h);
//			nameBText.setFont("default-36.font");
			nameBText.setFlags(RSRC_HALIGN_LEFT);
			nameBText.setValue(name);
			
			statusBText = new BText(this, 170, 0, 250, h);
//			statusBText.setFont("default-36.font");
			statusBText.setFlags(RSRC_HALIGN_LEFT);
			setStatus(status);
		}
		
		public void setStatus(String status) {
			statusBText.setValue(status);
		}
		
		public Spinner start() {
			Spinner spinner = new Spinner(this, 0, 0, 34, 34);
			return (spinner);
		}
	}
}
