package tivonage;

import java.text.SimpleDateFormat;

import com.mutchek.vonaje.Click2CallException;
import com.mutchek.vonaje.Message;
import com.mutchek.vonaje.PhoneNumber;

import com.tivo.hme.bananas.BApplication;
import com.tivo.hme.bananas.BText;
import com.tivo.hme.bananas.BView;
import com.tivo.hme.sdk.HmeEvent.Key;

import basescreens.ProgramDetail;

/**
 * @author <a href="http://www.martiansoftware.com/contact.html">Marty Lamb</a>
 */
public class MessageDetailScreen extends ProgramDetail {

	private Message message;
	
	private static final String OPTION_PLAY = "Play";
	private static final String OPTION_CALL = "Return call";
	private static final String OPTION_DELETE = "Delete now";
	private static final String OPTION_RETURN = "Don't do anything";

	private SimpleDateFormat day;
	private SimpleDateFormat time;
	private java.text.DecimalFormat seconds;
	private boolean isCallable = true;
	
	private static final String[] OPTIONS = {OPTION_PLAY, OPTION_CALL, OPTION_DELETE, OPTION_RETURN};
	private static final String[] OPTIONS_UNKNOWN_CALLER = {OPTION_PLAY, OPTION_DELETE, OPTION_RETURN};
	private BText messageSource;
	private BText messageDetail;
	private BText messageDesc;
	
	private BView newMessageIndicator;
	
	public MessageDetailScreen(BApplication app) {
		super(app, OPTIONS);
		setBackground("blue.jpg");
		setTitle(TiVonage.TITLE);
		
		day = new SimpleDateFormat("EEE M/d");
		time = new SimpleDateFormat("h:mm a");
		seconds = new java.text.DecimalFormat("00");
		
		newMessageIndicator = new BView(normal, 48, 265, SCREEN_WIDTH, 34, false);
		BView newMessageIcon = new BView(newMessageIndicator, 0, 0, 34, 34);
    	newMessageIcon.setResource("star.png");
    	BText newMessageText = new BText(newMessageIndicator, 34, 0, SCREEN_WIDTH, 34);
    	newMessageText.setFont("default-18.font");
    	newMessageText.setFlags(RSRC_HALIGN_LEFT);
    	newMessageText.setValue("You have not yet listened to this message.");

    	messageSource = new BText(this.normal, SAFE_TITLE_H + 10, SAFE_TITLE_V + 90, SCREEN_WIDTH, 48);
		messageSource.setFont("default-36.font");
		messageSource.setFlags(RSRC_HALIGN_LEFT);
		
		messageDesc = new BText(this.normal, SAFE_TITLE_H + 10, SAFE_TITLE_V + 140, SCREEN_WIDTH, 48 * 3);
		messageDesc.setFont("default-24.font");
		messageDesc.setFlags(RSRC_HALIGN_LEFT | RSRC_VALIGN_TOP | RSRC_TEXT_WRAP);
		
		messageDetail = new BText(this.normal, SCREEN_WIDTH / 2, 300, (SCREEN_WIDTH - 2 * SAFE_TITLE_H)/2, 60);
		messageDetail.setFont("default-18.font");
		messageDetail.setFlags(RSRC_HALIGN_RIGHT | RSRC_TEXT_WRAP | RSRC_VALIGN_TOP);
	}

    public boolean handleEnter(Object arg, boolean isReturn) {
    	if (message != null) {
    		newMessageIndicator.setVisible(message.isNew());
    	}
    	return (true);
    }
    
    boolean isCallable(Message message) {
    	return (PhoneNumber.isValidNumber(message.getCallerNumber()));
    }
    
	void setMessage(Message message) {
		this.message = message;
		
		isCallable=  isCallable(message);
		if (isCallable) {
			setOptions(OPTIONS);
		} else {
			setOptions(OPTIONS_UNKNOWN_CALLER);
		}
		
//		setTitle(message.getNumber());
		if (menu.size() > 0) {
			menu.setFocus(0, false);
		}
		
		if (message.getCallerName() == null || message.getCallerName().trim().length() == 0) {
			messageSource.setValue(PhoneNumber.format(message.getCallerNumber()));
			messageDesc.setValue("");
		} else {
			messageSource.setValue(message.getCallerName());
			messageDesc.setValue(PhoneNumber.format(message.getCallerNumber()) + "\n" + message.getCallerAddress());
		}
		messageDetail.setValue( 
				day.format(message.getCallTime()) + " " + time.format(message.getCallTime()).toLowerCase() + "\n"
				+ "Duration: " + formatDuration(message.getDuration()));
		newMessageIndicator.setVisible(message.isNew());
	}
	
	private String formatDuration(int durationSeconds) {
		return ((durationSeconds / 60) + ":" + seconds.format(durationSeconds % 60));
	}
	
    public void delete(boolean deleteFromList, boolean pressedClear) {
    	DeleteScreen deleteScreen = ((TiVonage) getBApp()).deleteScreen;
    	deleteScreen.setDeleteFromList(deleteFromList);
    	deleteScreen.setPressedClear(pressedClear);
    	deleteScreen.setMessage(message);
		getBApp().push(deleteScreen, TRANSITION_NONE);
    }
    
    public boolean handleKeyPress(int code, long rawCode) {
//    	System.out.println("KEYRESS:" +code);
 //   	System.out.println("RAWCODE:" + rawCode);
    	if (code == KEY_CLEAR) {
    		menu.setFocus(2, false);
    		play("select.snd");
    		delete(false, true);
    	} else if (code == KEY_SELECT) {
    		((TiVonage) getBApp()).dispatchKeyEvent(new Key(menu.getID(), KEY_PRESS, KEY_RIGHT, rawCode));
    	} else if (code == KEY_PLAY) {
    		menu.setFocus(0, false);
    		((TiVonage) getBApp()).dispatchKeyEvent(new Key(menu.getID(), KEY_PRESS, KEY_RIGHT, rawCode));
    		
    	}
    	return (false);
    }

    
    public boolean handleAction(BView view, Object action) {
//    	System.out.println(action);
    	if (action.equals("pop")) {
    		getBApp().pop(menu.get(menu.getFocus()));
    		return (true);
    	} else if (action.equals("push")) {
    		String optionText = isCallable ? OPTIONS[menu.getFocus()] : OPTIONS_UNKNOWN_CALLER[menu.getFocus()];
    		if (OPTION_RETURN.equals(optionText)) {
    			getBApp().pop(optionText);
    			return (true);
    		} else if (OPTION_DELETE.equals(optionText)) {
    			delete(false, false);
    			return (true);
    		} else if (OPTION_PLAY.equals(optionText)) {
    			PlayScreen ps = ((TiVonage) getBApp()).playScreen;
    			ps.setMessage(message);
    			getBApp().push(ps, TRANSITION_NONE);
    		} else if (OPTION_CALL.equals(optionText)) {
    			try {
    				message.getVonagePhoneNumber().initiateCall(message.getCallerNumber());
    			} catch (Click2CallException e) {
    				// TODO: display error for user?
    				//e.printStackTrace();
    				System.out.println("Unable to initiate call to " + message.getCallerNumber() + ": " + e.getMessage());
    			}
    			getBApp().pop(optionText);
    		}
    	}
    	return (super.handleAction(view, action));
    }
}
