package tivonage;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;


import basescreens.NowPlaying;

import com.mutchek.vonaje.Message;
import com.mutchek.vonaje.PhoneNumber;
import com.tivo.hme.bananas.BApplication;
import com.tivo.hme.bananas.BText;
import com.tivo.hme.bananas.BView;
import com.tivo.hme.sdk.HmeEvent.Key;

/**
 * The main menu screen
 *  
 * @author <a href="http://www.martiansoftware.com/contact.html">Marty Lamb</a>
 */
public class MainMenuScreen extends NowPlaying implements Runnable {

	private SimpleDateFormat dayOfWeek;
	private SimpleDateFormat dayOfMonth;
	private SimpleDateFormat time;

	private static final String MSG_NOMESSAGES = "No Messages";
	private static final String MSG_ERROR = "Unable to connect to Vonage.";
	private static final String MSG_NEWVERSION = "New Software Available!";
	
	private boolean gettingMessages;
	private boolean isFirstTimeCheckingMessages;
	
	private Properties errorProperties;
	
	private BView checkingMessage;
//	private BView checkingIcon;
	private Spinner spinner;
	
	public MainMenuScreen(BApplication app) {
		super(app);
		setTitle(TiVonage.TITLE);
		setBackground("blue.jpg");
        list.setPainting(false);
	}
	
	public boolean handleEnter(Object o, boolean isReturn) {
		isFirstTimeCheckingMessages = !isReturn;
//		if (isFirstTimeCheckingMessages) {
			new Thread(this).start();
//		}
		return (true);
	}
	
	private void init() {
		dayOfWeek = new SimpleDateFormat("EEE");
		dayOfMonth = new SimpleDateFormat("M/d");
		time = new SimpleDateFormat("h:mm a");

		checkingMessage = new BView(normal, SAFE_TITLE_H + 10, SAFE_TITLE_V + 90, SCREEN_WIDTH, 34, false);
		spinner = new Spinner(checkingMessage, 0, 0, 34, 34);
		spinner.setSilent(false);
    	
    	BText checkingText = new BText(checkingMessage, 34, 0, SCREEN_WIDTH, 34);
        checkingText.setShadow(true);
        checkingText.setFlags(RSRC_HALIGN_LEFT);
        checkingText.setValue("Checking for new messages...");
	}
	
	public void populateList() {
//		System.out.println("populating");
		init();
		flush();
//		System.out.println("done populating");
	}
	
	void setGettingMessages(boolean gettingMessages) {
		this.gettingMessages = gettingMessages;
		if (!gettingMessages) {
			spinner.stop(true);
		}
		spinner.setVisible(gettingMessages && isFirstTimeCheckingMessages);
	}
	
	public boolean isGettingMessages() {
		return (gettingMessages);
	}
	
	public void delete(Message message) {
		synchronized(list) {
			normal.setPainting(false);
			int focus = list.getFocus();
			boolean noMessages = false;
			
			// this is weird.  it seems you DO NOT want the size of your BList to
			// go down to zero, as it does something internally that results in
			// null pointer exceptions (perhaps some kind of optimization that
			// assumes it can free resources?)  So if you're deleting the last item
			// from the list, you should insert its replacement before deleting it.
			if (list.size() < 2) {
				list.add(MSG_NOMESSAGES);
				noMessages = true;
			}

			list.remove(message);
			if (noMessages) {
				list.setFocusable(false);
			} else {
				list.setFocus(Math.min(focus, list.size()), false);
			}
			normal.setPainting(true);
		}
	}
	
    public boolean handleAction(BView view, Object action) {
//    	System.out.println(action);
        if (action.equals("push")) {
        	Object rowObject = list.get(list.getFocus());
        	if (rowObject instanceof Message) {
	        	Message message = (Message) rowObject;
	        	
	        	MessageDetailScreen messageDetailScreen = ((TiVonage) getBApp()).messageDetailScreen;
	        	messageDetailScreen.setMessage(message);
	            getBApp().push(messageDetailScreen, TRANSITION_NONE);
	            list.setVisible(false);
    		} else if (rowObject.equals(MSG_NEWVERSION)) {

    			InfoScreen infoScreen = ((TiVonage) getBApp()).infoScreen;
    			infoScreen.setInfo(TiVonage.getNewerVersionProperties());
    			getBApp().push(infoScreen, TRANSITION_NONE);
    			list.setVisible(false);
    		} else if (rowObject.equals(MSG_ERROR)) {
    			InfoScreen infoScreen = ((TiVonage) getBApp()).infoScreen;
    			infoScreen.setInfo(errorProperties);
    			getBApp().push(infoScreen, TRANSITION_NONE);
    			list.setVisible(false);
    		} else {
        		play("bonk.snd");
        	}
            return true;
        	// else if (action.equals("pop")) {
        } else if (action.equals("pop")) {
        	// why does this play bonk?
        	getBApp().setActive(false);
//        	return (true);
        }
       return super.handleAction(view, action);
    }
    
    public boolean handleKeyPress(int code, long rawCode) {
    	if (code == KEY_CLEAR) {
    		if (list.size() > 0) {
	    		Object rowObject = list.get(list.getFocus());
	    		if (rowObject instanceof Message) {
	        		play("select.snd");
	        		list.setVisible(false);
		    		MessageDetailScreen messageDetailScreen = ((TiVonage) getBApp()).messageDetailScreen;
		    		messageDetailScreen.setMessage((Message) list.get(list.getFocus()));
		    		messageDetailScreen.delete(true, true);
	    		} else {
	    			play("bonk.snd");
	    		}
	    		return(true);
    		}
    	} else if (code == KEY_SELECT) {
    		play("select.snd");
    		((TiVonage) getBApp()).dispatchKeyEvent(new Key(list.getID(), KEY_PRESS, KEY_RIGHT, rawCode));
    	} else if (code == KEY_PLAY) {
    		if (list.size() > 0) {
	    		Object rowObject = list.get(list.getFocus());
	    		if (rowObject instanceof Message) {
	        		play("select.snd");
	    			PlayScreen ps = ((TiVonage) getBApp()).playScreen;
	    			
	    			ps.setMessage((Message) rowObject);
	    			list.setVisible(false);
	    			getBApp().push(ps, TRANSITION_NONE);
	    		} else {
	    			play("bonk.snd");
	    		}
	    		return(true);
    		}
    		
    	} else if (code == KEY_LEFT) {
    		getBApp().setActive(false);
    		return (true);
    	}
    	return (super.handleKeyPress(code, rawCode));
    }

    public void createRow(BView parent, int index) {   
    	Object rowObject = list.get(index);
    	if (rowObject instanceof Message) {
	        Message msg = (Message) rowObject;
	        
	        if (msg.isNew()) {
	        	BView icon = new BView(parent, 0, 0, 34, parent.height);
	        	icon.setResource("star.png");
	        }
	
	        BText text = new BText(parent, 34, 4, 250 - 34, parent.height - 4);
	        text.setShadow(true);
	        text.setFlags(RSRC_HALIGN_LEFT);
	        String txt = msg.getCallerName();
	        text.setValue((txt == null || txt.trim().length() == 0) ? PhoneNumber.format(msg.getCallerNumber()) : txt);
	        
	        text = new BText(parent, 235, 4, 50, parent.height - 4);
	        text.setFlags(RSRC_HALIGN_RIGHT);
	        text.setValue(dayOfWeek.format(msg.getCallTime()));
	
	        text = new BText(parent, 290, 4, 75, parent.height - 4);
	        text.setFlags(RSRC_HALIGN_RIGHT);
	        text.setValue(dayOfMonth.format(msg.getCallTime()));
	
	        text = new BText(parent, 375, 4, 90, parent.height - 4);
	        text.setFlags(RSRC_HALIGN_RIGHT);
	        text.setValue(time.format(msg.getCallTime()).toLowerCase());
    	} else {
	        if (rowObject.equals(MSG_NEWVERSION) || rowObject.equals(MSG_ERROR)) {
	        	BView icon = new BView(parent, 0, 0, 34, parent.height);
	        	icon.setResource("envelope.png");
	        }

    		BText text = new BText(parent, 34, 4, 350, parent.height - 4);
	        text.setShadow(true);
	        text.setFlags(RSRC_HALIGN_LEFT);
	        text.setValue(rowObject);
    	}
    }

	public void run() {
		int oldFocus = list.getFocus();
		list.setVisible(false);
		list.flush();
		try {
			list.clear();
		} catch (Exception e) {
			// BList can't handle becoming empty.
			// it can *start* empty just fine, but it will
			// throw up if you clear it.  I ignore that here.
			// e.printStackTrace();
		}
//		list.add(0, "");
//		list.setFocus(0, false);
		
		list.setPainting(false);
		
		setGettingMessages(true);
		checkingMessage.setVisible(isFirstTimeCheckingMessages);
		flush();
		boolean err = false;
		
		TiVonage tivonage = (TiVonage) getBApp();
		com.mutchek.vonaje.VonagePhoneNumber number = tivonage.getPhoneNumber();
		List messages = null;
		try {
			messages = number.getMessageList();
		} catch (Exception e) {
			e.printStackTrace();
			messages = new java.util.ArrayList();
			err = true;
			errorProperties = new Properties();
			SimpleDateFormat fmt = new SimpleDateFormat("MMMMM d, yyyy");
			errorProperties.setProperty("date", fmt.format(new java.util.Date()));
			errorProperties.setProperty("message", "TiVonage was unable to check your messages.\n"
													+ "\n"
													+ "Vonage may be performing maintenance on their website,\n"
													+ "or there may be a networking problem.  If the problem\n"
													+ "persists, try logging in to Vonage from a PC.  If you\n"
													+ "are able to connect, check your TiVo's network connection.\n"
													+ "If not, try again later.");
		}
		
		synchronized(list) {
			for (java.util.Iterator i = messages.iterator(); i.hasNext();) {
				Message message = (Message) i.next();
				list.add(message);
				list.flush();
			}
			
			// if there are no messages AT ALL,
			// display that message in a  unfocusable list.
			
			// if there are no messages BUT there's a new
			// version, display the new version message in
			// a focusable list.
			
			// if there's an error retrieving the messages,
			// add that to the focusable list.
//			for (int i = 0; i < oldSize; ++i) list.remove(0);
			if (TiVonage.getNewerVersionProperties() != null) {
				list.add(0, MSG_NEWVERSION);
				list.setFocus(0, false);
				list.setFocusable(true);
			}
			
			if (list.size() == 0 && errorProperties == null) {
				list.add(MSG_NOMESSAGES);
				list.setFocusable(false);
			}
			
			if (errorProperties != null) {
				list.add(MSG_ERROR);
				list.setFocus(0, false);
				list.setFocusable(true);
			}
//			if (list.size() > 0) {
//				list.setFocus(0, false);
//			} else {
//				list.add(err ? MSG_ERROR : MSG_NOMESSAGES);
//			}
			
//			if (TiVonage.getNewerVersionProperties() != null) {
//				list.add(0, MSG_NEWVERSION);
//				list.setFocus(0, false);
//			}
		}
		
		checkingMessage.setVisible(false);
		checkingMessage.flush();
		list.setPainting(true);
		list.setVisible(true);
		if (messages.size() > 0) {
			list.setFocus(oldFocus < list.size() ? oldFocus: list.size() - 1, false);
		}
		list.flush();
		setGettingMessages(false);
	}
}
