package tivonage;

import java.io.File;

import martianutils.lang.ProcessResult;

/**
 * Wraps the mp3 encoder executable for thumbnail creation.
 * 
 * @author <a href="http://www.martiansoftware.com/contact.html">Marty Lamb</a>
 */
public class MP3Encoder {

	public static final long GIVEUP_THRESHOLD_MS = 60000;
	public static MP3Encoder SINGLETON = new MP3Encoder();
	private String[] cmdline;
	
	public void setCommandLine(String command) {
		this.cmdline = command.split(" ");
	}
	
	public boolean convert(File workingdir, File from, File to) {
		String[] cmdarray = new String[cmdline.length];
		for (int i = 0; i < cmdline.length; ++i) {
			if ("$1".equals(cmdline[i])) {
				cmdarray[i] = from.toString();
			} else if ("$2".equals(cmdline[i])) {
				cmdarray[i] = to.toString();
			} else {
				cmdarray[i] = cmdline[i];
			}
		}

		boolean result = false;
		String[] envp = {};
		ProcessResult pr = null;
		try {
			pr = new ProcessResult(Runtime.getRuntime().exec(cmdarray, envp, workingdir), GIVEUP_THRESHOLD_MS);
			pr.waitFor();
			if ((pr.getProcess().exitValue() == 0) && to.exists()) {
				result = true;
			}
		} catch (Throwable t) {
			// TODO: decide whether to just swallow this
			t.printStackTrace();
		}
		if (pr != null) {
			System.err.println(pr.getOutputString());
			System.err.println(pr.getErrorString());
		}
		return (result);
	}
	
}
