package tivonage;

import java.util.Properties;

import com.mutchek.vonaje.Click2CallException;
import com.tivo.hme.bananas.BApplication;
import com.tivo.hme.bananas.BText;
import com.tivo.hme.bananas.BView;
import com.tivo.hme.sdk.HmeEvent.Key;

import basescreens.ProgramDetail;
import basescreens.RowCreator;

public class InfoScreen extends ProgramDetail {

	private BText date;
	private BText msg;
	private static final String[] options = { "Finished reading message" };
	
	public InfoScreen(BApplication app) {
		super(app, options);
		setBackground("blue.jpg");
		setTitle(TiVonage.TITLE);

		date = new BText(this.normal, SCREEN_WIDTH / 2, SCREEN_HEIGHT - SAFE_TITLE_V - 20, (SCREEN_WIDTH - 2 * SAFE_TITLE_H)/2, 60);
		date.setFont("default-18.font");
		date.setFlags(RSRC_HALIGN_RIGHT | RSRC_TEXT_WRAP | RSRC_VALIGN_TOP);
		
		msg = new BText(this.normal, SAFE_TITLE_H + 10, SAFE_TITLE_V + 90, SCREEN_WIDTH, 48 * 8);
		msg.setFont("default-24.font");
		msg.setFlags(RSRC_HALIGN_LEFT | RSRC_VALIGN_TOP | RSRC_TEXT_WRAP);

	}
	
	public void setInfo(Properties info) {
		date.setValue(info.getProperty("date", ""));
		msg.setValue(info.getProperty("message", ""));
	}
	
	public void createRow(BView parent, int index) {
        BText text = new BText(parent, 10, 4, parent.width - 34, parent.height - 4);
        text.setShadow(true);
        text.setFlags(RSRC_HALIGN_LEFT);
        text.setValue("Finished reading message.");
	}
	
    public boolean handleKeyPress(int code, long rawCode) {
    	if (code == KEY_ENTER) {
    		((TiVonage) getBApp()).dispatchKeyEvent(new Key(menu.getID(), KEY_PRESS, KEY_RIGHT, rawCode));
    	}
    	return (false);
    }

    public boolean handleAction(BView view, Object action) {
    	if (action.equals("pop") || action.equals("push")) {
    		getBApp().pop();
    		return (true);
    	}
    	return (super.handleAction(view, action));
    }

}
