package tivonage;

import java.text.SimpleDateFormat;
import java.util.TimerTask;

import com.mutchek.vonaje.Message;
import com.mutchek.vonaje.PhoneNumber;
import com.mutchek.vonaje.VonageConnectivityException;

import com.tivo.hme.bananas.BApplication;
import com.tivo.hme.bananas.BText;
import com.tivo.hme.bananas.BView;
import com.tivo.hme.sdk.HmeEvent.Key;

import basescreens.ProgramDetail;

/**
 * The message deletion confirmation screen
 *  
 * @author <a href="http://www.martiansoftware.com/contact.html">Marty Lamb</a>
 */
public class DeleteScreen extends ProgramDetail {

	private Message message;
	
	private static final String OPTION_DELETE = "Delete now";
	private static final String OPTION_DONTDELETE = "Don't delete";
	
	private static final String[] OPTIONS = {OPTION_DELETE, OPTION_DONTDELETE};
	private boolean deleteFromList = false;
	private boolean pressedClear = false;

//	private BText deleteMessage;
	
	private BText messageSource;
	private BText messageDetail;
	private BText messageDesc;
	
	private BView newMessageIndicator;

	private SimpleDateFormat day;
	private SimpleDateFormat time;
	private java.text.DecimalFormat seconds;

	
	public DeleteScreen(BApplication app) {
		super(app, OPTIONS);
		setBackground("blue.jpg");
		setTitle("Delete Message");
//		deleteMessage = new BText(this.normal, SAFE_TITLE_H + 10, SAFE_TITLE_V + 90, SCREEN_WIDTH - 2*SAFE_TITLE_H - 20, SCREEN_HEIGHT);
//		deleteMessage.setFont("default-24.font");
//		deleteMessage.setFlags(RSRC_HALIGN_LEFT | RSRC_TEXT_WRAP | RSRC_VALIGN_TOP);
		
		
		
		day = new SimpleDateFormat("EEE M/d");
		time = new SimpleDateFormat("h:mm a");
		seconds = new java.text.DecimalFormat("00");
		
		newMessageIndicator = new BView(normal, 48, 265, SCREEN_WIDTH, 34, false);
		BView newMessageIcon = new BView(newMessageIndicator, 0, 0, 34, 34);
    	newMessageIcon.setResource("star.png");
    	BText newMessageText = new BText(newMessageIndicator, 34, 0, SCREEN_WIDTH, 34);
    	newMessageText.setFont("default-18.font");
    	newMessageText.setFlags(RSRC_HALIGN_LEFT);
    	newMessageText.setValue("You have not yet listened to this message.");

		
    	messageSource = new BText(this.normal, SAFE_TITLE_H + 10, SAFE_TITLE_V + 90, SCREEN_WIDTH, 48);
		messageSource.setFont("default-36.font");
		messageSource.setFlags(RSRC_HALIGN_LEFT);
		
		messageDesc = new BText(this.normal, SAFE_TITLE_H + 10, SAFE_TITLE_V + 140, SCREEN_WIDTH, 48 * 3);
		messageDesc.setFont("default-24.font");
		messageDesc.setFlags(RSRC_HALIGN_LEFT | RSRC_VALIGN_TOP | RSRC_TEXT_WRAP);
		
		messageDetail = new BText(this.normal, SCREEN_WIDTH / 2, 300, (SCREEN_WIDTH - 2 * SAFE_TITLE_H)/2, 60);
		messageDetail.setFont("default-18.font");
		messageDetail.setFlags(RSRC_HALIGN_RIGHT | RSRC_TEXT_WRAP | RSRC_VALIGN_TOP);

	}

	void setMessage(Message message) {
		this.message = message;
		if (menu.size() > 0) {
			menu.setFocus(0, false);
		}
//		String desc = (message.getCallerName() == null) ? message.getCallerNumber() : message.getCallerName() + " (" + message.getCallerNumber() + ")";
//		String msg = desc + "\n"
//						+ "\n"
//						+ "Do you want to delete this message?"
//						+ (pressedClear ? "" : "\n\nTip: Press CLEAR in in the Voice Mail list to delete messages.");
//		deleteMessage.setValue(msg);

		if (message.getCallerName() == null || message.getCallerName().trim().length() == 0) {
			messageSource.setValue(PhoneNumber.format(message.getCallerNumber()));
			messageDesc.setValue("Do you want to delete this message?");
		} else {
			messageSource.setValue(message.getCallerName());
			messageDesc.setValue(PhoneNumber.format(message.getCallerNumber()) + "\n" + message.getCallerAddress() + "\n\nDo you want to delete this message?");
		}

		newMessageIndicator.setVisible(message.isNew());


	}
	
    public boolean handleEnter(Object arg, boolean isReturn) {
    	if (deleteFromList) {
    		play("alert.snd");
    	} else {
	    	TimerTask tt = new TimerTask() {
	    		public void run() {
	    	    	play("alert.snd");
	    	    	flush();
	    		}
	    	};
	    	TiVonage.timer.schedule(tt, 1000);
    	}
    	
    	return (super.handleEnter(arg, isReturn));
    }

    void setDeleteFromList(boolean deleteFromList) {
		this.deleteFromList = deleteFromList;
	}

    void setPressedClear(boolean pressedClear) {
    	this.pressedClear = pressedClear;
    }
    
    public boolean handleKeyPress(int code, long rawCode) {
    	if (code == KEY_SELECT) {
    		((TiVonage) getBApp()).dispatchKeyEvent(new Key(menu.getID(), KEY_PRESS, KEY_RIGHT, rawCode));
    	}
    	return (false);
    }
    
    public boolean handleAction(BView view, Object action) {
//    	System.out.println(action);
    	if (action.equals("pop")) {
    		getBApp().pop(menu.get(menu.getFocus()));
    		return (true);
    	} else if (action.equals("push")) {
    		String optionText = OPTIONS[menu.getFocus()];
    		if (OPTION_DONTDELETE.equals(optionText)) {
    			getBApp().pop(optionText);
    			return (true);
    		} else if (OPTION_DELETE.equals(optionText)) {
//    			System.out.println("Deleting message");
    			play("select.snd");
    			try {
//    				((TiVonage) getBApp()).
//    				message.getVonagePhoneNumber().getMessageList()
    				Thread t = new Thread() {
    					public void run() {
    						try {
    							message.delete();
    						} catch (Exception e) {
    							e.printStackTrace();
    						}
    					}
    				};
    				t.setDaemon(true);
    				t.start();
    				
    				// this is *HORRIBLE* coding here.  the deletion takes
    				// some time, but is reflected immediately in the message
    				// list.  so I run this delete in another thread (above)
    				// and ASSUME that a second is long enough for the
    				// delete to be reflected.  This also assumes that the
    				// delete is ultimately successful.  The RIGHT thing to do
    				// would be to create a "Please Wait" overlay and do the
    				// whole thing synchronously.
    				Thread.sleep(1000);
//    				java.util.ArrayList al = message.getVonagePhoneNumber().getMessageList();
//    				message.getVonagePhoneNumber().deleteMessage(al.indexOf(message));
    			} catch (Exception e) {
    				e.printStackTrace();
    				// TODO: something smarter than this, that's for sure
    			}
    			// pop all the way back to message list if necessary
    			getBApp().pop(optionText);
    			if (!deleteFromList) getBApp().pop(optionText);
    			return (true);
    		}
    	}
    	return (super.handleAction(view, action));
    }
}
