/*
 * Copyright (c) 2005, John Mutchek
 * Redistribution and use in source and binary forms, with or 
 * without modification, are permitted provided that the following 
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above 
 *    copyright notice, this list of conditions and the following 
 *    disclaimer in the documentation and/or other materials provided 
 *    with the distribution.
 * 3. The name of the author may not be used to endorse or promote 
 *    products derived from this software without specific prior 
 *    written permission.
 *    
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR 
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED 
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND 
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Vonage is a reserved mark of Vonage Holdings Corp. which has no
 * affiliation with this open project.  As this source may make 
 * use of services exposed by Vonage to Vonage customers at 
 * http://www.vonage.com, users should be aware of,
 * and heed, the Vonage Terms of Service as described at
 * http://www.vonage.com/features_terms_service.php
 * 
 */

package com.mutchek.vonaje;

/**
 * Generic phone thisNumber class providing utility methods
 * @author jmutchek
 */

public class PhoneNumber {

	/**
	 * The 11-digit phone number represented by an instance of
	 * this class
	 */
	private String thisNumber = "";
	
	public PhoneNumber(String number) throws InvalidPhoneNumberException {
//		if (isValidNumber(number)) {
			this.thisNumber = number;
//		} else {
//			throw new InvalidPhoneNumberException();
//		}
	}
	
	/**
	 * Retrieve the 11-digit phone number
	 * @return the 11-digit phone number
	 */
	public String getNumber() {
		return thisNumber;
	}
	
	/**
	 * Retrieve the 11-digit phone number
	 */
	public String toString() {
		return thisNumber;
	}
	
	/**
	 * Retrieve a formatted copy of this phone number
	 * @see format()
	 */
	public String format() {
		return format(thisNumber);
	}
	
	/**
	 * Retrieve a formatted copy of this phone number
	 * @see formatWithoutParens()
	 */
	public String formatWithoutParens() {
		return formatWithoutParens(thisNumber);
	}
	
	/**
	 * Validate that the supplied thisNumber is valid and in the right format
	 * @param thisNumber to be validated
	 * @return true if it is a valid, well-formed 11-digit phone thisNumber
	 */
	public static boolean isValidNumber(String number) {
		return (number != null) && (number.matches("^[\\d]{11}$"));		
	}

	public boolean isValidNumber() {
		return isValidNumber(thisNumber);
	}
	
	/**
	 * Retrieve a formatted version of an 11-digit phone number that
	 * looks like (123) 456-7890
	 * @param number 11-digit number to be formatted
	 * @return the formatted phone number
	 */
	public static String format(String number) {
		if (!isValidNumber(number)) return number;
		return "(" + number.substring(1,4) + ") " + number.substring(4,7) + "-" + number.substring(7); 
	}
	
	/**
	 * Retrieve a formatted version of an 11-digit phone number that
	 * looks like 123-456-7890
	 * @param number 11-digit number to be formatted
	 * @return the formatted phone number
	 */
	public static String formatWithoutParens(String number) {
		if (!isValidNumber(number)) return number;
		return number.substring(1,4) + "-" + number.substring(4,7) + "-" + number.substring(7);		
	}
	
}
