package basescreens;

import com.tivo.hme.bananas.BApplication;
import com.tivo.hme.bananas.BList;
import com.tivo.hme.bananas.BText;
import com.tivo.hme.bananas.BView;

/**
 * Mimics the structure of the standard TiVo program detail screen.
 *  
 * @author <a href="http://www.martiansoftware.com/contact.html">Marty Lamb</a>
 */
public abstract class ProgramDetail extends BaseScreen implements RowCreator {
	
	protected static final int PROGDETAIL_LISTWIDTH = SCREEN_WIDTH / 2 - 40;
	protected static final int PROGDETAIL_LISTBOTTOM = SCREEN_HEIGHT - SAFE_TITLE_V;
	protected static final int PROGDETAIL_LISTLEFT = SAFE_TITLE_H + 10;
	protected static final int PROGDETAIL_ROWHEIGHT = 35;
	protected BList menu;
	
	private String[] options;
	
	/**
	 * Creates a new Program Detail-style screen
	 * @param app the application containing the screen
	 * @param options the menu options to show (e.g., "Play", "Delete", etc.)
	 */
	public ProgramDetail(BApplication app, String[] options) {
		super(app);
		
		int top = PROGDETAIL_LISTBOTTOM - PROGDETAIL_ROWHEIGHT * options.length;
        menu = new DelegatingBList(this.normal, PROGDETAIL_LISTLEFT, top, PROGDETAIL_LISTWIDTH, SCREEN_HEIGHT, PROGDETAIL_ROWHEIGHT, this);
        setOptions(options);
	}

	public void setOptions(String[] options) {

		int num2Del = menu.size();

		if (options != null) {
        	for (int i = 0; i < options.length; ++i) {
        		menu.add(options[i]);
        	}
        }

		for (int i = 0; i < num2Del; ++i) menu.remove(0);
        if (menu.size() > 0) {
        	menu.setFocus(0, true);
        }

	}
	/**
	 * Builds the menu row by row
	 */
	public void createRow(BView parent, int index) {
        BText text = new BText(parent, 10, 4, parent.width - 34, parent.height - 4);
        text.setShadow(true);
        text.setFlags(RSRC_HALIGN_LEFT);
        text.setValue(menu.get(index).toString());
	}
	
    public boolean handleAction(BView view, Object action) {
    	return (super.handleAction(view, action));
    }
}
