package basescreens;

import com.tivo.hme.bananas.BApplication;
import com.tivo.hme.bananas.BHighlights;
import com.tivo.hme.bananas.BList;
import com.tivo.hme.bananas.BView;

/**
 * A screen that mimics the structure of TiVo's Now Playing screen.
 * 
 * @author <a href="http://www.martiansoftware.com/contact.html">Marty Lamb</a>
 */
public abstract class NowPlaying extends BaseScreen implements RowCreator {

	protected static final int NOWPLAYING_LISTWIDTH = SCREEN_WIDTH - (2 * SAFE_TITLE_H) - 20;
	protected static final int NOWPLAYING_LISTHEIGHT = 285;
	protected static final int NOWPLAYING_LISTLEFT = SAFE_TITLE_H + 10;
	protected static final int NOWPLAYING_LISTTOP = SCREEN_HEIGHT - SAFE_TITLE_V - 290;
	protected static final int NOWPLAYING_ROWHEIGHT = 35;
	
	protected BList list;
	
	/**
	 * Creates a new Now Playing-style screen
	 * @see BScreen(BApplication)
	 */
	public NowPlaying(BApplication app) {
		super(app);

        list = new DelegatingBList(this.normal, NOWPLAYING_LISTLEFT, NOWPLAYING_LISTTOP, NOWPLAYING_LISTWIDTH, NOWPLAYING_LISTHEIGHT, NOWPLAYING_ROWHEIGHT, this);
        
        // this is necessary for the pageup/pagedn indicators
        BHighlights h = list.getHighlights();
        h.setPageHint(H_PAGEUP,   A_RIGHT+13, A_TOP    - 25);
        h.setPageHint(H_PAGEDOWN, A_RIGHT+13, A_BOTTOM + 30);
        
        populateList();
        if (list.size() > 0) {
        	list.setFocus(0, true);
        }
	}
	
	/**
	 * Returns this screen's title
	 */
	public String toString() {
		return (getTitle());
	}
	
    public boolean handleAction(BView view, Object action) {
    	return (super.handleAction(view, action));
    }

    /**
     * Subclasses should override this method to populate the list
     * of items to display (in the protected "list" object).
     */
    public abstract void populateList();
}
