package basescreens;

import com.tivo.hme.bananas.BList;
import com.tivo.hme.bananas.BView;

/**
 * A simple extension of BList that sets default look and feel parameters.
 * The createRow() method is delegated to a RowCreator that is set in the constructor.
 * 
 * @author <a href="http://www.martiansoftware.com/contact.html">Marty Lamb</a>
 */
class DelegatingBList extends BList {

	private RowCreator rowCreator;
	
    public DelegatingBList(BView parent, int x, int y, int width, int height, int rowHeight, RowCreator rowCreator) {
        super(parent, x, y, width, height, rowHeight);
        setBarAndArrows(BAR_HANG, BAR_DEFAULT, "pop", "push");
        this.rowCreator = rowCreator;
    }

    protected void createRow(BView parent, int index) {
    	rowCreator.createRow(parent, index);
    }
}
