package basescreens;

import java.awt.Color;

import com.tivo.hme.bananas.BApplication;
import com.tivo.hme.bananas.BText;

/**
 * Just a very simple base class for some helpers that mimic the
 * structure of standard TiVo screens.
 * 
 * @author <a href="http://www.martiansoftware.com/contact.html">Marty Lamb</a>
 */
public class BaseScreen extends com.tivo.hme.bananas.BScreen {

	public static final int SCREEN_WIDTH = 640;
	public static final int SCREEN_HEIGHT = 480;
	
	protected BText titleView;
	protected String title;
	
	/**
	 * Creates a new BaseScreen
	 * @see BScreen(BApplication)
	 */
	public BaseScreen(BApplication app) {
		super(app);
        titleView = new BText(normal, SAFE_TITLE_H+100, SAFE_TITLE_V, (width-(SAFE_TITLE_H*2))-100, 54);
        titleView.setColor(java.awt.Color.YELLOW);
        titleView.setShadow(Color.black, 3);
        titleView.setFlags(RSRC_VALIGN_TOP | RSRC_HALIGN_CENTER);
        titleView.setFont("default-48.font");
        titleView.setValue("");
	}

	/**
	 * Sets the screen title
	 * @param title the screen title
	 */
	public void setTitle(String title) {
		this.title = title;
		titleView.setValue(title);
	}
	
	/**
	 * Returns the screen title
	 * @return the screen title
	 */
	public String getTitle() {
		return (title);
	}
	
	/**
	 * Sets the background resouce
	 * @param backgroundResource the background resource to use (e.g., "background.png")
	 */
	public void setBackground(String backgroundResource) {
		below.setResource(backgroundResource);
	}
	
	
	
}
