/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.hme.util;

import java.util.Enumeration;
import java.util.Vector;

public class ArgumentList {
    Vector args;

    public String getValue(String string) {
        String string2 = this.getValue(string, null);
        if (string2 == null) {
            throw new BadArgumentException(string + " is required");
        }
        return string2;
    }

    public int getInt(String string) {
        try {
            return Integer.parseInt(this.getValue(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadArgumentException(string + " should be a number");
        }
    }

    public String shift() {
        if (this.args.size() == 0) {
            throw new BadArgumentException("missing argument");
        }
        String string = (String)this.args.elementAt(0);
        this.args.removeElementAt(0);
        return string;
    }

    public String getValue(String string, String string2) {
        int n = this.args.indexOf(string);
        if (n == -1) {
            return string2;
        }
        this.args.removeElementAt(n);
        if (n == this.args.size()) {
            throw new BadArgumentException(string + " needs a parameter");
        }
        String string3 = (String)this.args.elementAt(n);
        if (string3.startsWith("-")) {
            throw new BadArgumentException(string + " needs a parameter");
        }
        this.args.removeElementAt(n);
        return string3;
    }

    public int getInt(String string, int n) {
        String string2 = this.getValue(string, null);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadArgumentException(string + " should be a number");
        }
    }

    public boolean getBoolean(String string) {
        int n = this.args.indexOf(string);
        if (n == -1) {
            return false;
        }
        this.args.removeElementAt(n);
        return true;
    }

    public void checkForIllegalFlags() {
        Enumeration enumeration = this.args.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("-")) continue;
            throw new BadArgumentException("don't understand " + string);
        }
    }

    public String[] getRemainingArgs() {
        Object[] objectArray = new String[this.args.size()];
        this.args.copyInto(objectArray);
        return objectArray;
    }

    public int getRemainingCount() {
        return this.args.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.args.size()) {
            String string;
            if (n != 0) {
                stringBuffer.append(' ');
            }
            if ((string = (String)this.args.elementAt(n)).indexOf(32) != -1 && !string.startsWith("\"")) {
                stringBuffer.append('\"');
                stringBuffer.append(string);
                stringBuffer.append('\"');
            } else {
                stringBuffer.append(string);
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    public static void main(String[] stringArray) {
        ArgumentList argumentList = new ArgumentList(stringArray);
        String string = argumentList.getValue("-must");
        int n = argumentList.getInt("-mustint");
        String string2 = argumentList.getValue("-param", "default");
        int n2 = argumentList.getInt("-paramint", 1775);
        boolean bl = argumentList.getBoolean("-f");
        argumentList.checkForIllegalFlags();
        System.out.println("must = " + string);
        System.out.println("mustInt = " + n);
        System.out.println("param = " + string2);
        System.out.println("paramInt = " + n2);
        System.out.println("flag = " + bl);
        String[] stringArray2 = argumentList.getRemainingArgs();
        int n3 = 0;
        while (n3 < stringArray2.length) {
            System.out.println(n3 + " = " + stringArray2[n3]);
            ++n3;
        }
    }

    public ArgumentList(ArgumentList argumentList) {
        this.args = new Vector(argumentList.args);
    }

    public ArgumentList(String[] stringArray) {
        this.args = new Vector(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            this.args.addElement(stringArray[n]);
            ++n;
        }
    }

    public ArgumentList(String string) {
        this.args = new Vector();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\"': {
                    if (bl) {
                        this.args.addElement(new String(stringBuffer));
                        stringBuffer.setLength(0);
                    }
                    bl ^= true;
                    break;
                }
                case ' ': {
                    if (!bl) {
                        if (stringBuffer.length() <= 0) break;
                        this.args.addElement(new String(stringBuffer));
                        stringBuffer.setLength(0);
                        break;
                    }
                    stringBuffer.append(c);
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        if (stringBuffer.length() > 0) {
            this.args.addElement(new String(stringBuffer));
            stringBuffer.setLength(0);
        }
    }

    public static class BadArgumentException
    extends RuntimeException {
        public BadArgumentException(String string) {
            super(string);
        }
    }
}

