/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.hme.sdk;

import com.tivo.hme.sdk.Application;
import com.tivo.hme.sdk.HmeEvent;
import com.tivo.hme.sdk.HmeObject;
import com.tivo.hme.sdk.Resource;
import com.tivo.hme.sdk.StreamResource;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class View
extends HmeObject {
    static View[] EMPTY = new View[0];
    public View parent;
    public Resource resource;
    public int flags;
    public int x;
    public int y;
    public int width;
    public int height;
    public int tx;
    public int ty;
    public float sx;
    public float sy;
    public float transparency;
    public boolean painting;
    public boolean visible;
    public int nchildren;
    public View[] children;

    public void remove() {
        this.remove(null);
    }

    public void remove(Resource resource) {
        this.parent.removeChild(this);
        this.resource = null;
        if (this.app.focus == this) {
            this.app.setFocus(null);
        }
        this.app.cmdViewRemove(this.id, resource);
        this.id = -1;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Point getTranslate() {
        return new Point(this.tx, this.ty);
    }

    public void setLocation(int n, int n2) {
        this.setBounds(n, n2, this.width, this.height, null);
    }

    public void setLocation(int n, int n2, Resource resource) {
        this.setBounds(n, n2, this.width, this.height, resource);
    }

    public void setSize(int n, int n2) {
        this.setBounds(this.x, this.y, n, n2, null);
    }

    public void setSize(int n, int n2, Resource resource) {
        this.setBounds(this.x, this.y, n, n2, resource);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4, null);
    }

    public void setBounds(int n, int n2, int n3, int n4, Resource resource) {
        if (resource == null && this.x == n && this.y == n2 && this.width == n3 && this.height == n4) {
            return;
        }
        this.app.cmdViewSetBounds(this.id, n, n2, n3, n4, resource);
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public void setScale(float f, float f2) {
        this.setScale(f, f2, null);
    }

    public void setScale(float f, float f2, Resource resource) {
        if (resource == null && this.sx == f && this.sy == f2) {
            return;
        }
        this.app.cmdViewSetScale(this.id, f, f2, resource);
        this.sx = f;
        this.sy = f2;
    }

    public void setTranslation(int n, int n2) {
        this.setTranslation(n, n2, null);
    }

    public void setTranslation(int n, int n2, Resource resource) {
        if (resource == null && this.tx == n && this.ty == n2) {
            return;
        }
        this.app.cmdViewSetTranslation(this.id, n, n2, resource);
        this.tx = n;
        this.ty = n2;
    }

    public void translate(int n, int n2) {
        this.translate(n, n2, null);
    }

    public void translate(int n, int n2, Resource resource) {
        this.setTranslation(this.tx + n, this.ty + n2, resource);
    }

    public void setVisible(boolean bl) {
        this.setVisible(bl, null);
    }

    public void setVisible(boolean bl, Resource resource) {
        if (resource == null && this.visible == bl) {
            return;
        }
        this.app.cmdViewSetVisible(this.id, bl, resource);
        this.visible = bl;
    }

    public void setTransparency(float f) {
        this.setTransparency(f, null);
    }

    public void setTransparency(float f, Resource resource) {
        if (resource == null && this.transparency == f) {
            return;
        }
        this.app.cmdViewSetTransparency(this.id, f, resource);
        this.transparency = f;
    }

    public void setPainting(boolean bl) {
        if (this.painting == bl) {
            return;
        }
        this.app.cmdViewSetPainting(this.id, bl);
        this.painting = bl;
    }

    public void clearResource() {
        this.setResource(null, 0);
    }

    public void setResource(Object object) {
        this.setResource(this.app.getResource(object), 0);
    }

    public void setResource(Object object, int n) {
        this.setResource(this.app.getResource(object), n);
    }

    public void setResource(Resource resource) {
        this.setResource(resource, 0);
    }

    public void setResource(Resource resource, int n) {
        if (resource != null && resource == this.resource && n == this.flags) {
            return;
        }
        this.app.cmdViewSetResource(this.id, resource, n);
        if (resource != this.resource) {
            if (this.resource instanceof StreamResource) {
                ((StreamResource)this.resource).removeHandler(this);
            }
            this.resource = resource;
            if (this.resource instanceof StreamResource) {
                ((StreamResource)this.resource).addHandler(this);
            }
        }
    }

    public void setFocus() {
        this.app.setFocus(this);
    }

    public boolean hasFocus() {
        boolean bl = false;
        if (this.app.focus == this) {
            bl = true;
        }
        return bl;
    }

    public boolean handleFocus(boolean bl) {
        return false;
    }

    public void postEvent(HmeEvent hmeEvent) {
        if (!this.handleEvent(hmeEvent)) {
            if (this.parent != null) {
                this.parent.postEvent(hmeEvent);
            } else if (this.app != null) {
                this.app.postEvent(hmeEvent);
            }
        }
    }

    void addChild(View view) {
        if (this.nchildren == this.children.length) {
            this.children = new View[this.nchildren + 5];
            System.arraycopy(this.children, 0, this.children, 0, this.nchildren);
        }
        this.children[this.nchildren++] = view;
        view.parent = this;
    }

    void removeChild(View view) {
        int n = 0;
        while (n < this.nchildren) {
            if (this.children[n] == view) {
                if (n < this.nchildren - 1) {
                    System.arraycopy(this.children, n + 1, this.children, n, this.nchildren - n - 1);
                }
                this.children[--this.nchildren] = null;
                break;
            }
            ++n;
        }
    }

    public void dump(int n) {
        int n2 = 0;
        while (n2 < n) {
            System.out.print(" ");
            ++n2;
        }
        System.out.println(this);
        if (this.resource != null) {
            this.resource.dump(n + 2);
        }
        n2 = 0;
        while (n2 < this.nchildren) {
            this.children[n2].dump(n + 2);
            ++n2;
        }
    }

    protected void toString(StringBuffer stringBuffer) {
        stringBuffer.append(",bounds=" + this.x + ',' + this.y + ',' + this.width + 'x' + this.height);
        if (this.tx != 0 || this.ty != 0) {
            stringBuffer.append(",tx=" + this.tx + ",ty=" + this.ty);
        }
        if (this.sx != 1.0f || this.sy != 1.0f) {
            stringBuffer.append(",sx=" + this.sx + ",sy=" + this.sy);
        }
        if (this.transparency != 0.0f) {
            stringBuffer.append(",transparency=" + (int)(100.0f * this.transparency) + '%');
        }
        if (!this.visible) {
            stringBuffer.append(",!visible");
        }
        if (!this.painting) {
            stringBuffer.append(",!painting");
        }
    }

    private final /* synthetic */ void this() {
        this.sx = 1.0f;
        this.sy = 1.0f;
        this.transparency = 0.0f;
        this.painting = true;
        this.children = EMPTY;
    }

    View(Application application) {
        super(application, 2);
        this.this();
    }

    public View(View view, int n, int n2, int n3, int n4) {
        this(view, n, n2, n3, n4, true);
    }

    public View(View view, int n, int n2, int n3, int n4, boolean bl) {
        super(view.app, view.app.getNextID());
        this.this();
        this.parent = view;
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.visible = bl;
        view.addChild(this);
        this.app.cmdViewAdd(this.id, view, n, n2, n3, n4, bl);
    }
}

