/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.hme.sdk;

import com.tivo.hme.sdk.Application;
import com.tivo.hme.sdk.HmeEvent;
import com.tivo.hme.sdk.IHmeEventHandler;
import com.tivo.hme.sdk.Resource;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StreamResource
extends Resource {
    public static final int EVT_RSRC_STATUS = 101;
    static IHmeEventHandler[] EMPTY = new IHmeEventHandler[0];
    public String uri;
    public String contentType;
    public int status;
    public float speed;
    boolean play;
    int nhandlers;
    IHmeEventHandler[] handlers;

    public void addHandler(IHmeEventHandler iHmeEventHandler) {
        if (this.nhandlers == this.handlers.length) {
            this.handlers = new IHmeEventHandler[Math.max(1, this.nhandlers * 2)];
            System.arraycopy(this.handlers, 0, this.handlers, 0, this.nhandlers);
        }
        this.handlers[this.nhandlers++] = iHmeEventHandler;
    }

    public void removeHandler(IHmeEventHandler iHmeEventHandler) {
        int n = 0;
        while (n < this.nhandlers) {
            if (this.handlers[n] == iHmeEventHandler) {
                if (n < this.nhandlers - 1) {
                    System.arraycopy(this.handlers, n + 1, this.handlers, n, this.nhandlers - n - 1);
                }
                this.handlers[--this.nhandlers] = null;
                break;
            }
            ++n;
        }
    }

    public void postEvent(HmeEvent hmeEvent) {
        super.postEvent(hmeEvent);
        int n = 0;
        while (n < this.nhandlers) {
            this.handlers[n].postEvent(hmeEvent);
            ++n;
        }
    }

    public boolean handleEvent(HmeEvent hmeEvent) {
        switch (hmeEvent.opcode) {
            case 3: {
                HmeEvent.ResourceInfo resourceInfo = (HmeEvent.ResourceInfo)hmeEvent;
                if (resourceInfo.id != this.id) break;
                String string = (String)resourceInfo.map.get("speed");
                if (string != null) {
                    this.speed = (int)Float.parseFloat(string);
                }
                if (this.status == resourceInfo.status) break;
                this.status = resourceInfo.status;
                this.postEvent(new ResourceStatus(this, this.id, this.status, resourceInfo.map));
            }
        }
        return super.handleEvent(hmeEvent);
    }

    public void play() {
        this.setSpeed(1.0f);
    }

    public void pause() {
        this.setSpeed((float)this.isPaused());
    }

    public void close() {
        this.app.cmdRsrcClose(this.id);
    }

    public boolean isPaused() {
        boolean bl = false;
        if (this.speed == 0.0f) {
            bl = true;
        }
        return bl;
    }

    public void setPosition(long l) {
        this.app.cmdRsrcSetPosition(this.id, l);
    }

    public void setSpeed(float f) {
        this.app.cmdRsrcSetSpeed(this.id, f);
    }

    protected void toString(StringBuffer stringBuffer) {
        stringBuffer.append(",uri=" + this.uri);
    }

    private final /* synthetic */ void this() {
        this.handlers = EMPTY;
    }

    StreamResource() {
        this.this();
    }

    StreamResource(Application application, String string, String string2, boolean bl) {
        super(application);
        this.this();
        this.uri = string;
        this.contentType = string2;
        this.play = bl;
        this.status = 0;
        this.speed = -2.1474836E9f;
        application.cmdRsrcAddStream(this.id, string, string2, bl);
    }

    static class ResourceStatus
    extends HmeEvent.ResourceInfo {
        public String toString() {
            return this.id + ".RSRC_STATUS(" + ResourceStatus.statusToString(this.status) + ')';
        }

        ResourceStatus(StreamResource streamResource, int n, int n2, Map map) {
            super(streamResource, n, n2, map);
            this.opcode = 101;
        }
    }
}

