/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.hme.sdk;

import com.tivo.hme.sdk.Application;
import com.tivo.hme.sdk.HmeEvent;
import com.tivo.hme.sdk.HmeObject;
import java.awt.Color;
import java.awt.Font;

public class Resource
extends HmeObject {
    public void setActive(boolean bl) {
        this.app.cmdRsrcSetActive(this.id, bl);
    }

    public void sendEvent(HmeEvent hmeEvent) {
        this.sendEvent(hmeEvent, null);
    }

    public void sendEvent(HmeEvent hmeEvent, Resource resource) {
        this.app.cmdRsrcSendEvent(this.id, hmeEvent, resource);
    }

    public void remove() {
        if (this.id >= 100) {
            this.app.cmdRsrcRemove(this.id);
            this.id = -1;
        }
    }

    protected void finalize() {
        this.remove();
        this.flush();
    }

    public void dump(int n) {
        int n2 = 0;
        while (n2 < n) {
            System.out.print(" ");
            ++n2;
        }
        System.out.println(this);
    }

    protected Resource() {
        super(null, -1);
    }

    protected Resource(Application application) {
        this(application, application.getNextID());
    }

    protected Resource(Application application, int n) {
        super(application, n);
        application.addResource(new Integer(n), this);
    }

    static class ColorResource
    extends Resource {
        Color color;

        protected void toString(StringBuffer stringBuffer) {
            stringBuffer.append(",rgb=0x" + Integer.toHexString(this.color.getRGB()));
        }

        ColorResource(Application application, Color color) {
            super(application);
            this.color = color;
            application.cmdRsrcAddColor(this.id, color);
        }
    }

    static class TrueTypeResource
    extends Resource {
        String name;
        Font font;

        protected void toString(StringBuffer stringBuffer) {
            stringBuffer.append(",ttf=" + this.name + ",font=" + this.font);
        }

        TrueTypeResource(Application application, String string, int n) {
            super(application, n);
            this.name = string;
        }

        TrueTypeResource(Application application, String string) {
            super(application);
            this.name = string;
            if (string == null) {
                throw new NullPointerException("TrueTypeResource name == null");
            }
            application.cmdRsrcAddTtf(this.id, string);
        }
    }

    static class FontResource
    extends Resource {
        Resource ttf;
        int style;
        float size;

        protected void toString(StringBuffer stringBuffer) {
            boolean bl;
            boolean bl2 = false;
            if ((this.style & 1) != 0) {
                bl2 = true;
            }
            boolean bl3 = bl2;
            boolean bl4 = false;
            if ((this.style & 2) != 0) {
                bl4 = bl = true;
            }
            String string = bl3 ? (bl ? "bolditalic" : "bold") : (bl ? "italic" : "plain");
            stringBuffer.append(",font=" + this.ttf + ",style=" + string + ",size=" + this.size);
        }

        FontResource(Application application, Resource resource, int n, float f) {
            super(application);
            this.ttf = resource;
            this.style = n;
            this.size = f;
            application.cmdRsrcAddFont(this.id, resource, n, f);
        }
    }

    static class TextResource
    extends Resource {
        Resource font;
        Resource color;
        String text;

        protected void toString(StringBuffer stringBuffer) {
            stringBuffer.append(",txt=" + this.text);
        }

        TextResource(Application application, Resource resource, Resource resource2, String string) {
            super(application);
            this.font = resource;
            this.color = resource2;
            this.text = string;
            if (resource == null) {
                throw new NullPointerException("TextResource font == null");
            }
            if (string == null) {
                throw new NullPointerException("TextResource text == null");
            }
            application.cmdRsrcAddText(this.id, resource, resource2, string);
        }
    }

    static class AnimResource
    extends Resource {
        int duration;
        float ease;

        protected void toString(StringBuffer stringBuffer) {
            stringBuffer.append(",anim=[" + this.duration + ',' + this.ease + ']');
        }

        AnimResource(Application application, int n, float f) {
            super(application);
            this.duration = n;
            this.ease = f;
            application.cmdRsrcAddAnim(this.id, n, f);
        }
    }
}

