/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.hme.sdk;

import com.tivo.hme.http.server.HttpConnection;
import com.tivo.hme.http.server.HttpRequest;
import com.tivo.hme.http.server.HttpServer;
import com.tivo.hme.http.share.Query;
import com.tivo.hme.io.ChunkedInputStream;
import com.tivo.hme.io.ChunkedOutputStream;
import com.tivo.hme.io.FastInputStream;
import com.tivo.hme.io.FastOutputStream;
import com.tivo.hme.sdk.Application;
import com.tivo.hme.sdk.Factory;
import com.tivo.hme.sdk.IHmeProtocol;
import com.tivo.hme.util.ArgumentList;
import com.tivo.hme.util.Cookies;
import com.tivo.hme.util.Misc;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Listener
implements IHmeProtocol {
    public static boolean DEBUG = false;
    public static long tm0 = System.currentTimeMillis();
    public static final int DEFAULT_PORT = 7288;
    static final String ACCEPTOR_NAME = "Acceptor";
    int port;
    ConnectionHandler[] handlers;
    Map factories;

    ConnectionHandler createConnectionHandler(InetAddress inetAddress, InetAddress inetAddress2) throws IOException {
        JmDNS jmDNS = null;
        if (inetAddress != null) {
            try {
                jmDNS = new JmDNS(inetAddress);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.out.println(noClassDefFoundError.getMessage());
            }
        }
        try {
            return new ConnectionHandler(inetAddress, this.port, inetAddress2, jmDNS);
        }
        catch (BindException bindException) {
            if (this.port == 7288) {
                return new ConnectionHandler(inetAddress, 0, inetAddress2, jmDNS);
            }
            throw bindException;
        }
    }

    static boolean isIPAddress(String string) {
        boolean bl = false;
        if (Listener.isIPv4Address(string) || Listener.isIPv6Address(string)) {
            bl = true;
        }
        return bl;
    }

    static boolean isIPv4Address(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            ++n;
        }
        boolean bl = false;
        if (n == 4) {
            bl = true;
        }
        return bl;
    }

    static boolean isIPv6Address(String string) {
        if (string.indexOf(58) == -1) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                Integer.parseInt(stringTokenizer.nextToken(), 16);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    void printNetworkInterfaces() throws IOException {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            System.out.print("  " + networkInterface.getName());
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                InetAddress inetAddress = enumeration2.nextElement();
                System.out.print(" " + inetAddress.getHostAddress());
            }
            System.out.println();
        }
    }

    public int getPort() {
        return this.port;
    }

    public String[] getURIs() {
        String[] stringArray = new String[this.handlers.length * this.factories.size()];
        int n = 0;
        int n2 = 0;
        while (n2 < this.handlers.length) {
            String string = "http://" + this.handlers[n2].addr.getHostAddress() + ':' + this.handlers[n2].getPort();
            Iterator iterator = this.factories.values().iterator();
            while (iterator.hasNext()) {
                Factory factory = (Factory)iterator.next();
                stringArray[n++] = string + factory.getPath();
            }
            ++n2;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(Factory var1_1) throws IOException {
        var2_2 = this;
        synchronized (var2_2) {
            var4_3 = var1_1.getURI();
            if (this.getFactory(var4_3) != null) {
                System.out.println("WARNING : " + var4_3 + " already added.");
            }
            this.factories.put(var4_3, var1_1);
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
            var4_4 = 0;
            if (true) ** GOTO lbl31
        }
        do {
            block9: {
                var5_5 = this.handlers[var4_4].getServiceInfo(var1_1);
                var6_6 = this.handlers[var4_4].getInterface().getHostAddress();
                var7_7 = "http://" + var6_6 + ':' + this.handlers[var4_4].getPort() + var1_1.getPath();
                if (var1_1.dnssd != null) {
                    try {
                        var1_1.dnssd.registerService(var5_5.getName(), "_tivo_hme._tcp", var7_7);
                        Listener.dprintln("Registered [DNSSD] " + var5_5.getName() + ' ' + var7_7);
                        break block9;
                    }
                    catch (IOException var8_9) {
                        var1_1.dnssd.close();
                        var1_1.dnssd = null;
                    }
                }
                if ((var8_8 = this.handlers[var4_4].jmdns) != null) {
                    var8_8.registerService(var5_5);
                    Listener.dprintln("Registered " + var7_7);
                }
            }
            ++var4_4;
lbl31:
            // 2 sources

        } while (var4_4 < this.handlers.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(Factory var1_1) {
        var2_2 = this;
        synchronized (var2_2) {
            this.factories.remove(var1_1.getURI());
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
            var4_3 = 0;
            if (true) ** GOTO lbl19
        }
        do {
            if (var1_1.dnssd != null) {
                var1_1.dnssd.close();
                var1_1.dnssd = null;
            } else if (this.handlers[var4_3].jmdns != null) {
                this.handlers[var4_3].jmdns.unregisterService(this.handlers[var4_3].getServiceInfo(var1_1));
            }
            ++var4_3;
lbl19:
            // 2 sources

        } while (var4_3 < this.handlers.length);
        var1_1.close();
    }

    public Factory getFactory(String string) {
        return (Factory)this.factories.get(string);
    }

    public static void dprintln(String string) {
        System.out.println(System.currentTimeMillis() - tm0 + "ms: " + string);
    }

    public static String rsrcFlagsToString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        switch (n & 7) {
            case 1: {
                stringBuffer.append("left ");
                break;
            }
            case 2: {
                stringBuffer.append("hcenter ");
                break;
            }
            case 4: {
                stringBuffer.append("right ");
            }
        }
        switch (n & 0x70) {
            case 16: {
                stringBuffer.append("top ");
                break;
            }
            case 32: {
                stringBuffer.append("vcenter ");
                break;
            }
            case 64: {
                stringBuffer.append("bottom ");
            }
        }
        if ((n & 0x100) != 0) {
            stringBuffer.append("wrap ");
        }
        switch (n & 0x7000) {
            case 4096: {
                stringBuffer.append("hfit");
                break;
            }
            case 8192: {
                stringBuffer.append("vfit");
                break;
            }
            case 16384: {
                stringBuffer.append("bestfit");
            }
        }
        return stringBuffer.toString();
    }

    private final /* synthetic */ void this() {
        this.factories = new HashMap();
    }

    public Listener(ArgumentList argumentList) throws IOException {
        this(argumentList, 7288);
    }

    public Listener(ArgumentList argumentList, int n) throws IOException {
        Object object;
        this.this();
        DEBUG = argumentList.getBoolean("-d");
        tm0 = System.currentTimeMillis();
        this.port = n = argumentList.getInt("-port", n);
        Vector<ConnectionHandler> vector = new Vector<ConnectionHandler>();
        String string = argumentList.getValue("-s", null);
        if (string != null) {
            object = InetAddress.getByName(string);
            vector.addElement(this.createConnectionHandler(null, (InetAddress)object));
        } else {
            object = argumentList.getValue("-i", null);
            if (object != null) {
                do {
                    Object object2;
                    if (Listener.isIPAddress((String)object)) {
                        object2 = InetAddress.getByName((String)object);
                        vector.addElement(this.createConnectionHandler((InetAddress)object2, (InetAddress)object2));
                        continue;
                    }
                    object2 = NetworkInterface.getByName((String)object);
                    if (object2 == null) {
                        System.out.println("\"" + (String)object + "\" is not a valid ipv4, ipv6, or network interface name. The\nnetwork interfaces on this machine are:");
                        this.printNetworkInterfaces();
                        throw new IOException("network interface not found: " + (String)object);
                    }
                    Enumeration<InetAddress> enumeration = ((NetworkInterface)object2).getInetAddresses();
                    while (enumeration.hasMoreElements()) {
                        InetAddress inetAddress = enumeration.nextElement();
                        vector.addElement(this.createConnectionHandler(inetAddress, inetAddress));
                    }
                } while ((object = argumentList.getValue("-i", null)) != null);
            } else {
                boolean bl = false;
                boolean bl2 = false;
                InetAddress[] inetAddressArray = Misc.getInterfaces();
                int n2 = 0;
                while (n2 < inetAddressArray.length) {
                    InetAddress inetAddress = inetAddressArray[n2];
                    String string2 = inetAddress.getHostAddress();
                    if (!string2.equals("127.0.0.1")) {
                        if (string2.startsWith("169.254.")) {
                            if (!bl2) {
                                bl2 = true;
                                vector.addElement(this.createConnectionHandler(inetAddress, inetAddress));
                            }
                        } else if (!bl) {
                            bl = true;
                            vector.addElement(this.createConnectionHandler(inetAddress, inetAddress));
                        }
                    }
                    ++n2;
                }
            }
        }
        if ("true".equals(System.getProperty("hme.loopback"))) {
            object = InetAddress.getByName("127.0.0.1");
            vector.addElement(this.createConnectionHandler((InetAddress)object, (InetAddress)object));
        }
        this.handlers = new ConnectionHandler[vector.size()];
        vector.copyInto(this.handlers);
    }

    class ConnectionHandler
    extends HttpServer {
        JmDNS jmdns;
        InetAddress addr;

        public InetAddress getInterface() {
            return this.addr;
        }

        ServiceInfo getServiceInfo(Factory factory) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("path", factory.getPath());
            hashtable.put("version", "0.36");
            return new ServiceInfo("_tivo_hme._tcp.local.", factory.title + "._tivo_hme._tcp.local.", super.getPort(), 0, 0, hashtable);
        }

        public void handleAccept(Socket socket) {
            new Thread(new Acceptor(socket)).start();
        }

        void handleHME(HttpRequest httpRequest) throws IOException {
            int n;
            HttpConnection httpConnection = httpRequest.getConnection();
            FastInputStream fastInputStream = httpConnection.getInputStream();
            FastOutputStream fastOutputStream = httpConnection.getOutputStream();
            Socket socket = httpConnection.getSocket();
            socket.setTcpNoDelay(true);
            String string = httpRequest.get("cookie");
            if (string != null) {
                string = (String)Cookies.parseCookie(string).get("id");
            }
            fastOutputStream.print("HTTP/1.1 200 Ok\r\n");
            fastOutputStream.print("Content-type: application/x-hme\r\n");
            if (string == null) {
                string = Cookies.createRandomCookie();
                fastOutputStream.print("Set-Cookie: id=" + string + "; path=/; expires=Tue, 26-Apr-2022 19:00:00 GMT\r\n");
            }
            fastOutputStream.print("\r\n");
            fastOutputStream.writeInt(1396855894);
            fastOutputStream.writeInt(36);
            fastOutputStream.flush();
            int n2 = fastInputStream.readInt();
            if (n2 != 1396855894) {
                throw new IOException("bad magic: 0x" + Integer.toHexString(n2));
            }
            int n3 = fastInputStream.readInt();
            if (n3 < 36) {
                throw new IOException("version mismatch: 0x" + Integer.toHexString(n3));
            }
            URL uRL = new URL("http://" + this.getInterface().getHostAddress() + ':' + this.port);
            String string2 = httpRequest.getURI();
            uRL = new URL(uRL, string2);
            if (string2.startsWith("/")) {
                string2 = string2.substring(1);
            }
            if ((n = string2.indexOf(47)) < 0) {
                throw new IOException("application name missing: " + uRL);
            }
            String string3 = string2.substring(0, n);
            Factory factory = Listener.this.getFactory(string3);
            if (factory == null) {
                throw new IOException("no such application: " + string3);
            }
            Application.Context context = new Application.Context();
            context.listener = Listener.this;
            context.factory = factory;
            context.handler = this;
            context.uri = uRL;
            context.base = new URL(uRL, "/" + string3 + '/');
            context.params = new Query(uRL).getMap();
            context.s = socket;
            context.in = new ChunkedInputStream(fastInputStream, 4380);
            context.out = new ChunkedOutputStream((OutputStream)fastOutputStream, 4380);
            context.cookie = string;
            Listener.dprintln(socket.getInetAddress().getHostAddress() + " connect: " + context.uri);
            try {
                long l = System.currentTimeMillis();
                Application application = factory.createApplication();
                application.setContext(context);
                application.init(context);
                application.root.setVisible(true);
                application.flush();
                factory.active.addElement(application);
                if (DEBUG) {
                    Listener.dprintln("Listener: " + context.out.getCount() + " bytes to create " + application);
                    Listener.dprintln("Listener: time=" + (System.currentTimeMillis() - l) + "ms");
                }
                application.readEvents();
            }
            catch (SocketException socketException) {
                Listener.dprintln(socket.getInetAddress().getHostAddress() + " exit: " + context.uri);
            }
            catch (EOFException eOFException) {
                Listener.dprintln(socket.getInetAddress().getHostAddress() + " close: " + context.uri);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        public void handle(HttpRequest httpRequest) throws IOException {
            int n;
            Listener.dprintln(httpRequest.getInetAddress().getHostAddress() + " handleHTTP: " + httpRequest.getURI());
            String string = httpRequest.getURI();
            if (string.indexOf(58) > 0) {
                return;
            }
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            if ((n = string.indexOf(47)) < 0) {
                httpRequest.reply(404, "invalid application name");
                return;
            }
            String string2 = string.substring(0, n);
            Factory factory = Listener.this.getFactory(string2);
            if (factory == null) {
                httpRequest.reply(404, "no such application: " + string2);
                return;
            }
            String string3 = URLDecoder.decode(string.substring(n), "UTF-8");
            if (string3.startsWith("/")) {
                string3 = string3.substring(1);
            }
            if (string3.length() == 0 || string3.startsWith("?")) {
                this.handleHME(httpRequest);
            } else {
                factory.handleHTTP(httpRequest, string3);
            }
        }

        protected void handleException(HttpRequest httpRequest, Throwable throwable) {
        }

        void drain(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
            int n2;
            byte[] byArray = new byte[4380];
            int n3 = 0;
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) > 0 && (n == -1 || n3 < n)) {
                outputStream.write(byArray, 0, n2);
                n3 += n2;
            }
            outputStream.flush();
        }

        ConnectionHandler(InetAddress inetAddress, int n, InetAddress inetAddress2, JmDNS jmDNS) throws IOException {
            super("Listener", InetAddress.getLocalHost().getHostName(), inetAddress, n);
            this.addr = inetAddress2;
            this.jmdns = jmDNS;
            this.start();
        }

        class Acceptor
        implements Runnable {
            Socket s;

            public void run() {
                Thread.currentThread().setName(Listener.ACCEPTOR_NAME);
                try {
                    new HttpConnection(ConnectionHandler.this, this.s, this.s.getInputStream()).run();
                }
                catch (IOException iOException) {
                    Listener.dprintln(iOException.getMessage());
                }
            }

            Acceptor(Socket socket) {
                this.s = socket;
            }
        }
    }
}

