/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.hme.sdk;

import com.tivo.hme.io.FastOutputStream;
import com.tivo.hme.sdk.Application;
import com.tivo.hme.sdk.Resource;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public abstract class ImageResource
extends Resource {
    int width;
    int height;

    public int getWidth() {
        if (this.width == -1) {
            this.loadSize(this.getImage());
        }
        return this.width;
    }

    public int getHeight() {
        if (this.height == -1) {
            this.loadSize(this.getImage());
        }
        return this.height;
    }

    abstract Image getImage();

    void loadSize(Image image) {
        if (image.getWidth(null) == -1) {
            new ImageLoader(image);
        }
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
    }

    protected void toString(StringBuffer stringBuffer) {
        stringBuffer.append("," + this.width + 'x' + this.height);
    }

    ImageResource(Application application, int n, int n2) {
        super(application);
        this.width = n;
        this.height = n2;
    }

    private static class ImageLoader
    implements ImageObserver {
        Image image;
        boolean done;

        public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if ((n & 1) != 0 && (n & 2) != 0) {
                this.done = true;
                this.notify();
                return false;
            }
            if ((n & 0x40) != 0 || (n & 0x80) != 0) {
                System.out.println("could not load image");
                this.done = true;
                this.notify();
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        ImageLoader(Image image) {
            if (image.getWidth(this) == -1 || image.getHeight(this) == -1) {
                while (!this.done) {
                    try {
                        ImageLoader imageLoader = this;
                        synchronized (imageLoader) {
                            this.wait(100L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    static class ImageResourceImage
    extends ImageResource {
        Image image;

        public Image getImage() {
            return this.image;
        }

        ImageResourceImage(Application application, Image image) {
            super(application, -1, -1);
            this.image = image;
            application.cmdRsrcAddImage(this.id, image);
        }
    }

    static class ImageResourceBytes
    extends ImageResource {
        byte[] buf;
        int off;
        int len;

        public Image getImage() {
            return Toolkit.getDefaultToolkit().createImage(this.buf, this.off, this.len);
        }

        ImageResourceBytes(Application application, byte[] byArray, int n, int n2) {
            super(application, -1, -1);
            this.buf = byArray;
            this.off = n;
            this.len = n2;
            application.cmdRsrcAddImage(this.id, byArray, n, n2);
        }
    }

    static class ImageResourceFile
    extends ImageResource {
        String filename;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        public Image getImage() {
            if (new File(this.filename).exists()) {
                return Toolkit.getDefaultToolkit().createImage(this.filename);
            }
            try {
                Image image;
                InputStream inputStream = this.app.getStream(this.filename);
                if (inputStream == null) {
                    return null;
                }
                try {
                    int n;
                    FastOutputStream fastOutputStream = new FastOutputStream(4096);
                    byte[] byArray = new byte[4096];
                    while ((n = inputStream.read(byArray, 0, byArray.length)) >= 0) {
                        fastOutputStream.write(byArray, 0, n);
                    }
                    image = Toolkit.getDefaultToolkit().createImage(fastOutputStream.getBuffer(), 0, fastOutputStream.getCount());
                    Object var3_7 = null;
                }
                catch (Throwable throwable) {
                    Object var3_8 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return image;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }

        protected void toString(StringBuffer stringBuffer) {
            super.toString(stringBuffer);
            stringBuffer.append(",file=" + this.filename);
        }

        ImageResourceFile(Application application, String string) {
            super(application, -1, -1);
            this.filename = string;
            if (string == null) {
                throw new NullPointerException("ImageFileResource filename == null");
            }
            application.cmdRsrcAddImage(this.id, string);
        }
    }
}

