/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.hme.sdk;

import com.tivo.hme.http.share.Query;
import com.tivo.hme.sdk.Application;
import com.tivo.hme.sdk.HmeEvent;
import com.tivo.hme.sdk.IHmeEventHandler;
import com.tivo.hme.sdk.IHmeProtocol;
import com.tivo.hme.sdk.ImageResource;
import com.tivo.hme.sdk.Resource;
import com.tivo.hme.sdk.SoundResource;
import com.tivo.hme.sdk.StreamResource;
import java.awt.Color;
import java.awt.Image;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;

public abstract class HmeObject
implements IHmeEventHandler,
IHmeProtocol {
    Application app;
    int id;

    public Application getApp() {
        return this.app;
    }

    public int getID() {
        return this.id;
    }

    public Application.Context getContext() {
        return this.app.context;
    }

    public void postEvent(HmeEvent hmeEvent) {
        this.handleEvent(hmeEvent);
    }

    public boolean handleEvent(HmeEvent hmeEvent) {
        switch (hmeEvent.opcode) {
            case 4: {
                HmeEvent.Key key = (HmeEvent.Key)hmeEvent;
                switch (key.action) {
                    case 1: {
                        return this.handleKeyPress(key.code, key.rawcode);
                    }
                    case 2: {
                        return this.handleKeyRepeat(key.code, key.rawcode);
                    }
                    case 3: {
                        return this.handleKeyRelease(key.code, key.rawcode);
                    }
                }
            }
        }
        return false;
    }

    public boolean handleKeyPress(int n, long l) {
        return false;
    }

    public boolean handleKeyRepeat(int n, long l) {
        return false;
    }

    public boolean handleKeyRelease(int n, long l) {
        return false;
    }

    public Resource getResource(Object object) {
        return this.app.getResource(object);
    }

    public Resource createColor(Color color) {
        return new Resource.ColorResource(this.app, color);
    }

    public Resource createTrueType(String string) {
        return new Resource.TrueTypeResource(this.app, string);
    }

    public Resource createFont(String string, int n, int n2) {
        return new Resource.FontResource(this.app, this.getResource(string), n, n2);
    }

    public Resource createText(Object object, Object object2, String string) {
        return new Resource.TextResource(this.app, this.getResource(object), this.getResource(object2), string);
    }

    public SoundResource createSound(String string) {
        return new SoundResource(this.app, string);
    }

    public ImageResource createImage(String string) {
        return new ImageResource.ImageResourceFile(this.app, string);
    }

    public ImageResource createImage(Image image) {
        return new ImageResource.ImageResourceImage(this.app, image);
    }

    public ImageResource createImage(byte[] byArray) {
        return this.createImage(byArray, 0, byArray.length);
    }

    public ImageResource createImage(byte[] byArray, int n, int n2) {
        return new ImageResource.ImageResourceBytes(this.app, byArray, n, n2);
    }

    public StreamResource createStream(String string) {
        return this.createStream(string, null, true);
    }

    public StreamResource createStream(String string, String string2, boolean bl) {
        return new StreamResource(this.app, string, string2, bl);
    }

    public StreamResource createStream(String string, Map map) {
        String string2;
        String string3;
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
        Query query = new Query(uRL);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(uRL.getProtocol());
        stringBuffer.append("://");
        stringBuffer.append(uRL.getHost());
        stringBuffer.append(':');
        stringBuffer.append(uRL.getPort());
        stringBuffer.append(uRL.getPath());
        boolean bl = true;
        Iterator iterator = query.getKeys();
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            String string4 = string2 = map == null ? null : (String)map.get(string3);
            if (string2 == null) {
                string2 = query.get(string3);
            }
            stringBuffer.append(bl ? (char)'?' : '&');
            try {
                stringBuffer.append(URLEncoder.encode(string3, "UTF-8"));
                stringBuffer.append('=');
                stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            bl = false;
        }
        if (map != null) {
            iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                string2 = query.get(string3);
                if (string2 != null) continue;
                string2 = (String)map.get(string3);
                stringBuffer.append(bl ? (char)'?' : '&');
                try {
                    stringBuffer.append(URLEncoder.encode(string3, "UTF-8"));
                    stringBuffer.append('=');
                    stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
                bl = false;
            }
        }
        return this.createStream(stringBuffer.toString(), "application/x-hme", true);
    }

    public Resource createAnimation(int n) {
        return this.createAnimation(n, 0.0f);
    }

    public Resource createAnimation(int n, float f) {
        return new Resource.AnimResource(this.app, n, f);
    }

    public void flush() {
        this.app.flush();
    }

    public void play(String string) {
        SoundResource soundResource = (SoundResource)this.getResource(string);
        if (soundResource != null) {
            soundResource.play();
        }
    }

    protected void toString(StringBuffer stringBuffer) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        stringBuffer.append(string);
        stringBuffer.append("[#");
        stringBuffer.append(this.id);
        this.toString(stringBuffer);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    HmeObject(Application application, int n) {
        this.app = application;
        this.id = n;
    }
}

