/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.hme.sdk;

import com.tivo.hme.io.FastInputStream;
import com.tivo.hme.io.FastOutputStream;
import com.tivo.hme.sdk.Application;
import com.tivo.hme.sdk.IHmeProtocol;
import com.tivo.hme.sdk.Resource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class HmeEvent
implements IHmeProtocol {
    public int opcode;
    public int id;

    public void write(FastOutputStream fastOutputStream) throws IOException {
        throw new IOException("not a writable event");
    }

    protected void readMap(FastInputStream fastInputStream, Map map) throws IOException {
        int n = (int)fastInputStream.readVInt();
        int n2 = 0;
        while (n2 < n) {
            map.put(fastInputStream.readUTF(), fastInputStream.readUTF());
            ++n2;
        }
    }

    protected void writeMap(FastOutputStream fastOutputStream, Map map) throws IOException {
        fastOutputStream.writeVInt(map.size());
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            fastOutputStream.writeUTF(string);
            fastOutputStream.writeUTF(string2);
        }
    }

    public static class Key
    extends HmeEvent {
        static Map codeToString = new HashMap();
        static Map stringToCode = new HashMap();
        public int action;
        public int code;
        public long rawcode;

        public void write(FastOutputStream fastOutputStream) throws IOException {
            fastOutputStream.writeVInt(this.opcode);
            fastOutputStream.writeVInt(this.id);
            fastOutputStream.writeVInt(this.action);
            fastOutputStream.writeVInt(this.code);
            fastOutputStream.writeVInt(this.rawcode);
        }

        public static String actionToString(int n) {
            switch (n) {
                case 1: {
                    return "press";
                }
                case 2: {
                    return "repeat";
                }
                case 3: {
                    return "release";
                }
            }
            return "unknown action " + n;
        }

        public static String codeToString(int n) {
            String string = (String)codeToString.get(new Integer(n));
            return string != null ? string : "unknown code " + n;
        }

        public static int stringToCode(String string) {
            Integer n = (Integer)stringToCode.get(string);
            return n != null ? n : 0;
        }

        public String toString() {
            return "key(" + Key.actionToString(this.action) + ',' + Key.codeToString(this.code) + ',' + this.rawcode + ')';
        }

        static void addCodeString(int n, String string) {
            Integer n2 = new Integer(n);
            codeToString.put(n2, string);
            stringToCode.put(string, n2);
        }

        public Key(int n, int n2, int n3, long l) {
            this.opcode = 4;
            this.id = n;
            this.action = n2;
            this.code = n3;
            this.rawcode = l;
        }

        public Key(FastInputStream fastInputStream) throws IOException {
            this((int)fastInputStream.readVInt(), (int)fastInputStream.readVInt(), (int)fastInputStream.readVInt(), fastInputStream.readVInt());
        }

        static {
            Key.addCodeString(1, "tivo");
            Key.addCodeString(2, "up");
            Key.addCodeString(3, "down");
            Key.addCodeString(4, "left");
            Key.addCodeString(5, "right");
            Key.addCodeString(6, "select");
            Key.addCodeString(7, "play");
            Key.addCodeString(8, "pause");
            Key.addCodeString(9, "slow");
            Key.addCodeString(10, "reverse");
            Key.addCodeString(11, "forward");
            Key.addCodeString(12, "replay");
            Key.addCodeString(13, "advance");
            Key.addCodeString(14, "thumbsup");
            Key.addCodeString(15, "thumbsdown");
            Key.addCodeString(16, "volumeup");
            Key.addCodeString(17, "volumedown");
            Key.addCodeString(18, "channelup");
            Key.addCodeString(19, "channeldown");
            Key.addCodeString(20, "mute");
            Key.addCodeString(21, "record");
            Key.addCodeString(22, "window");
            Key.addCodeString(23, "livetv");
            Key.addCodeString(24, "exit");
            Key.addCodeString(25, "info");
            Key.addCodeString(26, "list");
            Key.addCodeString(27, "guide");
            Key.addCodeString(28, "clear");
            Key.addCodeString(29, "enter");
            Key.addCodeString(40, "num0");
            Key.addCodeString(41, "num1");
            Key.addCodeString(42, "num2");
            Key.addCodeString(43, "num3");
            Key.addCodeString(44, "num4");
            Key.addCodeString(45, "num5");
            Key.addCodeString(46, "num6");
            Key.addCodeString(47, "num7");
            Key.addCodeString(48, "num8");
            Key.addCodeString(49, "num9");
        }
    }

    public static class DeviceInfo
    extends HmeEvent {
        public Map map;

        public void write(FastOutputStream fastOutputStream) throws IOException {
            fastOutputStream.writeVInt(this.opcode);
            fastOutputStream.writeVInt(this.id);
            this.writeMap(fastOutputStream, this.map);
        }

        public String toString() {
            return this.id + ".DEVICE_INFO(" + this.map + ')';
        }

        public DeviceInfo(Map map) {
            this(1, map);
        }

        public DeviceInfo(int n, Map map) {
            this.opcode = 1;
            this.id = n;
            this.map = map;
        }

        public DeviceInfo(FastInputStream fastInputStream) throws IOException {
            this((int)fastInputStream.readVInt(), new HashMap());
            this.readMap(fastInputStream, this.map);
        }
    }

    public static class ApplicationInfo
    extends HmeEvent {
        public Map map;

        public void write(FastOutputStream fastOutputStream) throws IOException {
            fastOutputStream.writeVInt(this.opcode);
            fastOutputStream.writeVInt(this.id);
            this.writeMap(fastOutputStream, this.map);
        }

        public String toString() {
            return this.id + ".APP_INFO(" + this.map + ')';
        }

        public ApplicationInfo(Map map) {
            this(1, map);
        }

        public ApplicationInfo(int n, Map map) {
            this.opcode = 2;
            this.id = n;
            this.map = map;
        }

        public ApplicationInfo(int n, String string, String string2) {
            this.opcode = 2;
            this.id = n;
            this.map = new HashMap();
            this.map.put(string, string2);
        }

        public ApplicationInfo(FastInputStream fastInputStream) throws IOException {
            this((int)fastInputStream.readVInt(), new HashMap());
            this.readMap(fastInputStream, this.map);
        }
    }

    public static class ResourceInfo
    extends HmeEvent {
        public Resource rsrc;
        public int status;
        public Map map;

        public void write(FastOutputStream fastOutputStream) throws IOException {
            fastOutputStream.writeVInt(this.opcode);
            fastOutputStream.writeVInt(this.id);
            fastOutputStream.writeVInt(this.status);
            this.writeMap(fastOutputStream, this.map);
        }

        public static String statusToString(int n) {
            switch (n) {
                case 0: {
                    return "unknown";
                }
                case 2: {
                    return "connected";
                }
                case 1: {
                    return "connecting";
                }
                case 3: {
                    return "loading";
                }
                case 4: {
                    return "ready";
                }
                case 5: {
                    return "playing";
                }
                case 6: {
                    return "paused";
                }
                case 7: {
                    return "seeking";
                }
                case 8: {
                    return "closed";
                }
                case 9: {
                    return "complete";
                }
                case 10: {
                    return "error";
                }
            }
            return "unknown status " + n;
        }

        public String toString() {
            return this.id + ".RESOURCE_INFO(" + ResourceInfo.statusToString(this.status) + ", " + this.map + ')';
        }

        public ResourceInfo(int n, int n2, Map map) {
            this(null, n, n2, map);
        }

        public ResourceInfo(Resource resource, int n, int n2, Map map) {
            this.opcode = 3;
            this.rsrc = resource;
            this.id = n;
            this.status = n2;
            this.map = map;
        }

        public ResourceInfo(FastInputStream fastInputStream, Application application) throws IOException {
            this(null, (int)fastInputStream.readVInt(), (int)fastInputStream.readVInt(), new HashMap());
            this.readMap(fastInputStream, this.map);
            this.rsrc = application.getResource(this.id);
        }
    }
}

