/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.hme.sdk;

import com.tivo.hme.io.ChunkedInputStream;
import com.tivo.hme.io.ChunkedOutputStream;
import com.tivo.hme.io.FastOutputStream;
import com.tivo.hme.sdk.Factory;
import com.tivo.hme.sdk.HmeEvent;
import com.tivo.hme.sdk.HmeException;
import com.tivo.hme.sdk.Listener;
import com.tivo.hme.sdk.Resource;
import com.tivo.hme.sdk.SoundResource;
import com.tivo.hme.sdk.StreamResource;
import com.tivo.hme.sdk.View;
import com.tivo.hme.util.Misc;
import com.tivo.hme.util.Ticker;
import java.awt.Button;
import java.awt.Color;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Application
extends StreamResource {
    static final int AUTO_FLUSH_DELAY = 500;
    static Map systemIDs = new HashMap();
    public Context context;
    public View root;
    public int width;
    public int height;
    View focus;
    Map resources;
    int rsrcID;
    Thread eventThread;
    FlushSentinel flusher;
    Exception flushTrace;
    byte[] buf;

    synchronized int getNextID() {
        return this.rsrcID++;
    }

    void addResource(Resource resource) {
        this.addResource(new Integer(resource.id), resource);
    }

    void addResource(Object object, Resource resource) {
        this.resources.put(object, new WeakReference<Resource>(resource));
    }

    Resource getResource(int n) {
        return this.getResource(new Integer(n));
    }

    public synchronized Resource getResource(Object object) {
        Resource resource;
        if (object == null) {
            return null;
        }
        if (object instanceof Resource) {
            return (Resource)object;
        }
        WeakReference weakReference = (WeakReference)this.resources.get(object);
        Resource resource2 = resource = weakReference == null ? null : (Resource)weakReference.get();
        if (resource != null && resource.id == -1) {
            this.resources.remove(object);
            resource = null;
        }
        if (resource == null) {
            if (object instanceof String) {
                resource = this.createResource((String)object);
            } else if (object instanceof URL) {
                resource = this.createStream(((URL)object).toString());
            } else if (object instanceof Color) {
                resource = this.createColor((Color)object);
            } else if (object instanceof Image) {
                resource = this.createImage((Image)object);
            }
            if (resource != null) {
                this.addResource(object, resource);
            }
        }
        if (resource == null) {
            if (object instanceof Integer) {
                System.out.println(this + " warning: resource " + object + " not found.");
            } else {
                System.out.println(this + " warning: could not make resource from: '" + object + '\'');
            }
            if (Listener.DEBUG) {
                Thread.dumpStack();
            }
        }
        return resource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Resource createResource(String string) {
        String string2;
        if (string.indexOf("://") > 0) {
            return this.createStream(string);
        }
        if (string.startsWith("0x")) {
            String string3 = string.substring(2);
            try {
                int n = (int)Long.parseLong(string3, 16);
                boolean bl = false;
                if (string3.length() != 8) return this.createColor(new Color(n, bl));
                bl = true;
                return this.createColor(new Color(n, bl));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("'" + string + "' is not a valid color.");
            }
        }
        if (string.startsWith("*")) {
            try {
                int n;
                int n2 = string.indexOf(44);
                float f = 0.0f;
                if (n2 != -1) {
                    n = Integer.parseInt(string.substring(1, n2));
                    f = Float.parseFloat(string.substring(n2 + 1));
                    return this.createAnimation(n, f);
                } else {
                    n = Integer.parseInt(string.substring(1));
                }
                return this.createAnimation(n, f);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("'" + string + "' is not a valid anim");
            }
        }
        int n = string.lastIndexOf(46);
        String string4 = string2 = n < 0 ? "unknown" : string.substring(n).toLowerCase();
        if (string2.equals(".png") || string2.equals(".jpg") || string2.equals(".jpeg") || string2.equals(".gif") || string2.equals(".mpg")) {
            return this.createImage(string);
        }
        if (string2.equals(".snd")) {
            Integer n3 = (Integer)systemIDs.get(string.toLowerCase());
            if (n3 == null) return this.createSound(string);
            return new SoundResource(this, string, n3);
        }
        if (string2.equals(".ttf")) {
            Integer n4 = (Integer)systemIDs.get(string.toLowerCase());
            if (n4 == null) return this.createTrueType(string);
            return new Resource.TrueTypeResource(this, string, n4);
        }
        if (!string2.equals(".font")) throw new IllegalArgumentException("'" + string + "' is not a valid resource string.");
        int n5 = (string = string.substring(0, string.length() - ".font".length())).indexOf(45);
        if (n5 == -1) {
            throw new IllegalArgumentException("'" + string + "' is not a valid font.");
        }
        int n6 = string.indexOf(45, n5 + 1);
        String string5 = string.substring(0, n5) + ".ttf";
        int n7 = 0;
        try {
            int n8;
            if (n6 != -1) {
                n8 = Integer.parseInt(string.substring(n5 + 1, n6));
                String string6 = string.substring(n6 + 1).toLowerCase();
                if (string6.equals("bold")) {
                    n7 = 1;
                    return this.createFont(string5, n7, n8);
                } else if (string6.equals("italic")) {
                    n7 = 2;
                    return this.createFont(string5, n7, n8);
                } else {
                    if (!string6.equals("bolditalic")) throw new IllegalArgumentException("'" + string + "' is not a valid font.");
                    n7 = 3;
                }
                return this.createFont(string5, n7, n8);
            } else {
                n8 = Integer.parseInt(string.substring(n5 + 1));
            }
            return this.createFont(string5, n7, n8);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("'" + string + "' is not a valid font.");
        }
    }

    void setContext(Context context) {
        this.context = context;
        this.width = this.root.width = context.getParamInt("width", 640);
        this.height = this.root.height = context.getParamInt("height", 480);
        this.root.visible = false;
    }

    protected void init(Context context) throws Exception {
    }

    public synchronized void flush() {
        block3: {
            if (this.context == null) {
                return;
            }
            try {
                this.context.out.flush();
            }
            catch (IOException iOException) {
                if (this.context == null) break block3;
                this.close();
                iOException.printStackTrace();
                throw new HmeException("flush failed " + iOException);
            }
        }
    }

    public void close() {
        Context context = this.context;
        if (context != null) {
            this.context = null;
            try {
                context.s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            context.factory.active.removeElement(this);
            if (this.flusher != null) {
                Ticker.master.remove(this.flusher, null);
                this.flusher = null;
            }
        }
    }

    public void setFocus(View view) {
        if (this.focus != view) {
            if (this.focus != null) {
                this.focus.handleFocus(false);
            }
            this.focus = view;
            if (this.focus != null) {
                this.focus.handleFocus(true);
            }
        }
    }

    public View getFocus() {
        return this.focus;
    }

    public boolean handleEvent(HmeEvent hmeEvent) {
        switch (hmeEvent.opcode) {
            case 2: {
                HmeEvent.ApplicationInfo applicationInfo = (HmeEvent.ApplicationInfo)hmeEvent;
                if (applicationInfo.map.get("error.code") != null) {
                    int n = Integer.parseInt((String)applicationInfo.map.get("error.code"));
                    String string = (String)applicationInfo.map.get("error.text");
                    return this.handleApplicationError(n, string);
                }
                if (applicationInfo.map.get("active") == null) break;
                return this.handleActive("true".equals(applicationInfo.map.get("active")));
            }
        }
        return super.handleEvent(hmeEvent);
    }

    public boolean handleApplicationError(int n, String string) {
        System.out.println(this + " handleApplicationError(" + n + ',' + string + ')');
        return false;
    }

    public boolean handleActive(boolean bl) {
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void readEvents() throws IOException {
        try {
            this.eventThread = Thread.currentThread();
            while (true) lbl-1000:
            // 4 sources

            {
                this.flush();
                var3_1 = this.context.in;
                var4_2 = (int)var3_1.readVInt();
                if (var4_2 == -1) ** GOTO lbl-1000
                var5_3 /* !! */  = null;
                switch (var4_2) {
                    case 1: {
                        var5_3 /* !! */  = new HmeEvent.DeviceInfo(var3_1);
                        break;
                    }
                    case 2: {
                        var5_3 /* !! */  = new HmeEvent.ApplicationInfo(var3_1);
                        break;
                    }
                    case 3: {
                        var5_3 /* !! */  = new HmeEvent.ResourceInfo(var3_1, this);
                        break;
                    }
                    case 4: {
                        var5_3 /* !! */  = new HmeEvent.Key(var3_1);
                        break;
                    }
                }
                var3_1.readTerminator();
                if (var5_3 /* !! */  == null) {
                    Listener.dprintln("unknown event opcode : " + var4_2);
                    continue;
                }
                if (Listener.DEBUG) {
                    Listener.dprintln("event " + var5_3 /* !! */ );
                }
                try {
                    this.dispatchEvent(var5_3 /* !! */ );
                }
                catch (ThreadDeath var6_5) {
                    throw var6_5;
                }
                catch (Throwable var6_4) {
                    var6_4.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (Throwable var1_6) {
            var2_7 = null;
            this.eventThread = null;
            this.close();
            throw var1_6;
        }
        ** GOTO lbl-1000
lbl-1000:
        // 1 sources

        {
            var2_8 = null;
            this.eventThread = null;
            this.close();
            return;
        }
    }

    protected void dispatchEvent(HmeEvent hmeEvent) {
        switch (hmeEvent.opcode) {
            case 2: 
            case 3: {
                Resource resource = this.getResource(hmeEvent.id);
                if (resource == null) break;
                resource.postEvent(hmeEvent);
                break;
            }
            case 4: {
                View view = this.focus;
                if (view != null) {
                    view.postEvent(hmeEvent);
                    break;
                }
                this.postEvent(hmeEvent);
                break;
            }
            default: {
                this.postEvent(hmeEvent);
            }
        }
    }

    public InputStream getStream(String string) throws IOException {
        return this.context.factory.getStream(string);
    }

    FastOutputStream getStream(Image image) throws IOException {
        Object object;
        BufferedImage bufferedImage = null;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
        } else {
            if (image.getWidth(null) == -1 || image.getHeight(null) == -1) {
                object = new MediaTracker(new Button());
                ((MediaTracker)object).addImage(image, 0);
                try {
                    ((MediaTracker)object).waitForAll();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            bufferedImage.getGraphics().drawImage(image, 0, 0, null);
        }
        if (bufferedImage.getColorModel().getNumComponents() <= 3) {
            object = new FastOutputStream(4096);
            ImageIO.write((RenderedImage)bufferedImage, "jpg", (OutputStream)object);
            return object;
        }
        object = new FastOutputStream(4096);
        ImageIO.write((RenderedImage)bufferedImage, "png", (OutputStream)object);
        if (((FastOutputStream)object).getCount() <= 524288) {
            return object;
        }
        if (Listener.DEBUG) {
            Listener.dprintln("warning : discarding alpha for " + bufferedImage.getWidth(null) + 'x' + bufferedImage.getHeight(null));
        }
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(null), bufferedImage.getHeight(null), 1);
        bufferedImage2.getGraphics().drawImage(bufferedImage, 0, 0, null);
        object = new FastOutputStream(4096);
        ImageIO.write((RenderedImage)bufferedImage2, "jpg", (OutputStream)object);
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdViewAdd(int n, View view, int n2, int n3, int n4, int n5, boolean bl) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".VIEW_ADD(" + view.id + ',' + n2 + ',' + n3 + ',' + n4 + ',' + n5 + ',' + bl + ')');
        }
        try {
            try {
                this.writeCommand(1, n);
                this.context.out.writeVInt(view.id);
                this.context.out.writeVInt(n2);
                this.context.out.writeVInt(n3);
                this.context.out.writeVInt(n4);
                this.context.out.writeVInt(n5);
                this.context.out.writeBoolean(bl);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var9_11 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdViewSetBounds(int n, int n2, int n3, int n4, int n5, Resource resource) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".VIEW_SET_BOUNDS(" + n2 + ',' + n3 + ',' + n4 + ',' + n5 + ',' + resource + ')');
        }
        try {
            try {
                this.writeCommand(2, n);
                this.context.out.writeVInt(n2);
                this.context.out.writeVInt(n3);
                this.context.out.writeVInt(n4);
                this.context.out.writeVInt(n5);
                this.context.out.writeVInt(resource != null ? resource.id : 0);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var8_10 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdViewSetScale(int n, float f, float f2, Resource resource) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".VIEW_SET_SCALE(" + f + ',' + f2 + ',' + resource + ')');
        }
        try {
            try {
                this.writeCommand(3, n);
                this.context.out.writeFloat(f);
                this.context.out.writeFloat(f2);
                this.context.out.writeVInt(resource != null ? resource.id : 0);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdViewSetTranslation(int n, int n2, int n3, Resource resource) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".VIEW_SET_TRANSLATION(" + n2 + ',' + n3 + ',' + resource + ')');
        }
        try {
            try {
                this.writeCommand(4, n);
                this.context.out.writeVInt(n2);
                this.context.out.writeVInt(n3);
                this.context.out.writeVInt(resource != null ? resource.id : 0);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdViewSetTransparency(int n, float f, Resource resource) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".VIEW_SET_TRANSPARENCY(" + f + ',' + resource + ')');
        }
        try {
            try {
                this.writeCommand(5, n);
                this.context.out.writeFloat(f);
                this.context.out.writeVInt(resource != null ? resource.id : 0);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdViewSetVisible(int n, boolean bl, Resource resource) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".VIEW_SET_VISIBLE(" + bl + ',' + resource + ')');
        }
        try {
            try {
                this.writeCommand(6, n);
                this.context.out.writeBoolean(bl);
                this.context.out.writeVInt(resource != null ? resource.id : 0);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdViewSetPainting(int n, boolean bl) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".VIEW_SET_PAINTING(" + bl + ')');
        }
        try {
            try {
                this.writeCommand(7, n);
                this.context.out.writeBoolean(bl);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdViewSetResource(int n, Resource resource, int n2) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".VIEW_SET_RESOURCE(" + resource + ' ' + Listener.rsrcFlagsToString(n2) + ')');
        }
        try {
            try {
                this.writeCommand(8, n);
                this.context.out.writeVInt(resource != null ? resource.id : 0);
                this.context.out.writeVInt(n2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdViewRemove(int n, Resource resource) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".VIEW_REMOVE(" + resource + ')');
        }
        try {
            try {
                this.writeCommand(9, n);
                this.context.out.writeVInt(resource != null ? resource.id : 0);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdRsrcAddColor(int n, Color color) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".RSRC_ADD_COLOR(" + color + ')');
        }
        try {
            try {
                this.writeCommand(20, n);
                this.context.out.writeInt(color.getRGB());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdRsrcAddTtf(int n, String string) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".RSRC_ADD_TTF(" + string + ')');
        }
        try {
            try {
                this.writeCommand(21, n);
                this.writeStream(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdRsrcAddFont(int n, Resource resource, int n2, float f) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".RSRC_ADD_FONT(" + resource.id + ',' + n2 + ',' + f + ')');
        }
        try {
            try {
                this.writeCommand(22, n);
                this.context.out.writeVInt(resource.id);
                this.context.out.writeVInt(n2);
                this.context.out.writeFloat(f);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdRsrcAddText(int n, Resource resource, Resource resource2, String string) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".RSRC_ADD_TEXT(" + resource.id + ',' + resource2 + ',' + string + ')');
        }
        try {
            try {
                this.writeCommand(23, n);
                this.context.out.writeVInt(resource.id);
                this.context.out.writeVInt(resource2.id);
                this.context.out.writeUTF(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdRsrcAddImage(int n, Image image) {
        try {
            try {
                this.writeCommand(24, n);
                FastOutputStream fastOutputStream = this.getStream(image);
                if (Listener.DEBUG) {
                    Listener.dprintln(n + ".RSRC_ADD_IMAGE(... image => " + fastOutputStream.getCount() + " bytes ...)");
                }
                this.context.out.write(fastOutputStream.getBuffer(), 0, fastOutputStream.getCount());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var4_7 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdRsrcAddImage(int n, byte[] byArray, int n2, int n3) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".RSRC_ADD_IMAGE(len=" + n3 + ')');
        }
        try {
            try {
                this.writeCommand(24, n);
                this.context.out.write(byArray, n2, n3);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdRsrcAddImage(int n, String string) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".RSRC_ADD_IMAGE(" + string + ')');
        }
        try {
            try {
                this.writeCommand(24, n);
                this.writeStream(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdRsrcAddSound(int n, String string) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".RSRC_ADD_SOUND(" + string + ')');
        }
        try {
            try {
                this.writeCommand(25, n);
                this.writeStream(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdRsrcAddStream(int n, String string, String string2, boolean bl) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".RSRC_ADD_STREAM(" + string + ',' + string2 + ',' + bl + ')');
        }
        try {
            try {
                this.writeCommand(26, n);
                this.context.out.writeUTF(string);
                this.context.out.writeUTF(string2 == null ? "" : string2);
                this.context.out.write(bl ? 1 : 0);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdRsrcAddAnim(int n, int n2, float f) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".RSRC_ADD_ANIM(" + n2 + ',' + f + ')');
        }
        try {
            try {
                this.writeCommand(27, n);
                this.context.out.writeVInt(n2);
                this.context.out.writeFloat(f);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdRsrcSetActive(int n, boolean bl) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".RSRC_SET_ACTIVE(" + bl + ')');
        }
        try {
            try {
                this.writeCommand(40, n);
                this.context.out.writeBoolean(bl);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdRsrcSetPosition(int n, long l) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".RSRC_SET_POSITION(" + l + ')');
        }
        try {
            try {
                this.writeCommand(41, n);
                this.context.out.writeVInt(l);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var5_6 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdRsrcSetSpeed(int n, float f) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".RSRC_SET_SPEED(" + f + ')');
        }
        try {
            try {
                this.writeCommand(42, n);
                this.context.out.writeFloat(f);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdRsrcSendEvent(int n, HmeEvent hmeEvent, Resource resource) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".RSRC_SEND_EVENT(" + hmeEvent + ',' + resource + ')');
        }
        try {
            try {
                this.writeCommand(44, n);
                this.context.out.writeVInt(resource != null ? resource.id : 0);
                hmeEvent.write(this.context.out);
            }
            catch (IOException iOException) {
                throw new HmeException(iOException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdRsrcClose(int n) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".RSRC_CLOSE()");
        }
        try {
            try {
                this.writeCommand(45, n);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.writeTerminator();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void cmdRsrcRemove(int n) {
        if (Listener.DEBUG) {
            Listener.dprintln(n + ".RSRC_REMOVE()");
        }
        try {
            try {
                this.writeCommand(46, n);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close();
                throw new HmeException(iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.writeTerminator();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.writeTerminator();
            return;
        }
    }

    private final void writeCommand(int n, int n2) throws IOException {
        if (this.context == null) {
            throw new HmeException("application closed");
        }
        this.context.out.writeVInt(n);
        this.context.out.writeVInt(n2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeStream(String string) throws IOException {
        InputStream inputStream = this.app.getStream(string);
        try {
            int n;
            while ((n = inputStream.read(this.buf, 0, this.buf.length)) >= 0) {
                this.context.out.write(this.buf, 0, n);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        inputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeTerminator() {
        if (this.context == null) {
            return;
        }
        try {
            this.context.out.writeTerminator();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.close();
            throw new HmeException("I/O exception");
        }
        Thread thread = Thread.currentThread();
        if (thread != this.eventThread && !"Acceptor".equals(thread.getName())) {
            if (this.flusher == null) {
                Application application = this;
                synchronized (application) {
                    if (this.flusher == null) {
                        this.flusher = new FlushSentinel();
                    }
                }
            }
            this.flushTrace = new Exception("flush trace");
            Ticker.master.add(this.flusher, System.currentTimeMillis() + 500L, null);
        }
    }

    private final /* synthetic */ void this() {
        this.buf = new byte[4096];
    }

    protected Application() {
        this.this();
        this.app = this;
        this.id = 1;
        this.resources = new HashMap();
        this.rsrcID = 100;
        this.addResource(this);
        this.root = new View(this);
    }

    static {
        systemIDs.put("default.ttf", new Integer(10));
        systemIDs.put("system.ttf", new Integer(11));
        systemIDs.put("bonk.snd", new Integer(20));
        systemIDs.put("updown.snd", new Integer(21));
        systemIDs.put("thumbsup.snd", new Integer(22));
        systemIDs.put("thumbsdown.snd", new Integer(23));
        systemIDs.put("select.snd", new Integer(24));
        systemIDs.put("tivo.snd", new Integer(25));
        systemIDs.put("left.snd", new Integer(26));
        systemIDs.put("right.snd", new Integer(27));
        systemIDs.put("pageup.snd", new Integer(28));
        systemIDs.put("pagedown.snd", new Integer(29));
        systemIDs.put("alert.snd", new Integer(30));
        systemIDs.put("deselect.snd", new Integer(31));
        systemIDs.put("error.snd", new Integer(32));
        systemIDs.put("slowdown1.snd", new Integer(33));
        systemIDs.put("speedup1.snd", new Integer(34));
        systemIDs.put("speedup2.snd", new Integer(35));
        systemIDs.put("speedup3.snd", new Integer(36));
    }

    public static class Context {
        public Listener listener;
        public Factory factory;
        public URL uri;
        public URL base;
        String cookie;
        Map params;
        Properties state;
        Listener.ConnectionHandler handler;
        Socket s;
        ChunkedInputStream in;
        ChunkedOutputStream out;

        public Map getParameters() {
            return this.params;
        }

        public int getParamInt(String string, int n) {
            String string2 = this.getParamValue(string, null);
            return string2 == null ? n : Integer.parseInt(string2);
        }

        public String getParamValue(String string, String string2) {
            String string3 = (String)this.params.get(string);
            return string3 == null ? string2 : string3;
        }

        public InetAddress getInterface() {
            return this.handler.getInterface();
        }

        public int getPort() {
            return this.handler.getPort();
        }

        public ChunkedOutputStream getOutputStream() {
            return this.out;
        }

        public String getCookie() {
            return this.cookie;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized Properties getSessionState() {
            if (this.state != null) return this.state;
            this.state = new Properties();
            File file = this.getSessionFile();
            if (!file.exists()) return this.state;
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                try {
                    this.state.load(fileInputStream);
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    fileInputStream.close();
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                    fileInputStream.close();
                    return this.state;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return this.state;
        }

        public String getSessionValue(String string, String string2) {
            return this.getSessionState().getProperty(string, string2);
        }

        public void setSessionValue(String string, String string2) {
            this.getSessionState().setProperty(string, string2);
            this.saveSessionState();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        synchronized void saveSessionState() {
            if (this.state == null) return;
            File file = this.getSessionFile();
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                try {
                    this.state.store(fileOutputStream, this.base.toString());
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    fileOutputStream.close();
                    throw throwable;
                }
                {
                    Object var5_7 = null;
                    fileOutputStream.close();
                    return;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        File getSessionFile() {
            String string = Misc.isWindows() ? "Application Data/TiVo" : ".tivo";
            return new File(System.getProperty("user.home") + '/' + string + '/' + this.factory.uri, this.getCookie() + ".txt");
        }
    }

    class FlushSentinel
    implements Ticker.Client {
        public long tick(long l, Object object) {
            int n = Application.this.context.out.getUnflushedCount();
            if (n > 2) {
                Listener.dprintln(Application.this + " : warning, " + n + " bytes not flushed after 500ms.");
                Application.this.flushTrace.printStackTrace();
            }
            return 0L;
        }

        FlushSentinel() {
        }
    }
}

