/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.hme.io;

import java.io.IOException;
import java.io.OutputStream;

public class FastOutputStream
extends OutputStream {
    protected OutputStream out;
    protected byte[] buf;
    protected int pos;
    protected int posLimit;
    protected long limit;
    protected boolean limited;
    protected int count;

    private final void setBuffer(byte[] byArray) {
        this.buf = byArray;
        this.posLimit = byArray.length;
    }

    public void setLimit(long l) throws IOException {
        this.limit = l;
        boolean bl = false;
        if (l >= 0L) {
            bl = true;
        }
        this.limited = bl;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.pos];
        System.arraycopy(this.buf, 0, byArray, 0, this.pos);
        return byArray;
    }

    public int getCount() {
        return this.count + this.pos;
    }

    public void write(int n) throws IOException {
        if (this.limited) {
            if (this.limit <= 0L) {
                throw new IOException("output limit exceeded");
            }
            --this.limit;
        }
        if (this.pos == this.posLimit) {
            this.flush();
        }
        this.buf[this.pos++] = (byte)n;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.limited) {
            if ((long)n2 > this.limit) {
                throw new IOException("output limit exceeded");
            }
            this.limit -= (long)n2;
        }
        while (n2 > 0) {
            int n3 = this.posLimit - this.pos;
            if (n3 == 0) {
                this.flush();
                n3 = this.posLimit - this.pos;
            }
            int n4 = n3 > n2 ? n2 : n3;
            System.arraycopy(byArray, n, this.buf, this.pos, n4);
            this.pos += n4;
            n += n4;
            n2 -= n4;
        }
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public void writeShort(int n) throws IOException {
        this.write(n >>> 8);
        this.write(n);
    }

    public void writeInt(int n) throws IOException {
        this.write(n >>> 24);
        this.write(n >>> 16);
        this.write(n >>> 8);
        this.write(n);
    }

    public void writeLong(long l) throws IOException {
        int n = (int)(l >>> 32);
        int n2 = 1;
        this.writeInt(n);
        this.writeInt(n2);
    }

    public void writeVInt(long l) throws IOException {
        boolean bl;
        boolean bl2 = false;
        if (l < 0L) {
            bl2 = true;
        }
        if (bl = bl2) {
            l = -l;
        }
        while (l > 63L) {
            this.write((int)(l & 0x7FL));
            l >>= 7;
        }
        l = bl ? (l |= 0xC0L) : (l |= 0x80L);
        this.write((int)l);
    }

    /*
     * Unable to fully structure code
     */
    public void writeUnsignedInteger(long var1_1) throws IOException {
        if (var1_1 >= 0L) ** GOTO lbl5
        throw new IllegalArgumentException(var1_1 + " < 0");
lbl-1000:
        // 1 sources

        {
            this.write((int)(var1_1 & 127L));
            var1_1 >>>= 7;
lbl5:
            // 2 sources

            ** while (var1_1 > 127L)
        }
lbl6:
        // 1 sources

        this.write((int)(var1_1 | 128L));
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeUTF(String string) throws IOException {
        char c;
        int n = string.length();
        int n2 = 0;
        char[] cArray = new char[n];
        int n3 = 0;
        string.getChars(0, n, cArray, 0);
        int n4 = 0;
        while (n4 < n) {
            c = cArray[n4];
            n2 = c >= '\u0001' && c <= '\u007f' ? ++n2 : (c > '\u07ff' ? (n2 += 3) : (n2 += 2));
            ++n4;
        }
        if (n2 > (int)-1) {
            throw new IOException("string is too long");
        }
        byte[] byArray = new byte[n2 + 2];
        byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n3++] = (byte)(n2 & 0xFF);
        int n5 = 0;
        while (n5 < n) {
            c = cArray[n5];
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n3++] = (byte)c;
            } else if (c > '\u07ff') {
                byArray[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
            } else {
                byArray[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
            }
            ++n5;
        }
        this.write(byArray);
    }

    public void print(String string) throws IOException {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            this.write(string.charAt(n));
            ++n;
        }
    }

    public void println(String string) throws IOException {
        this.print(string);
        this.write(10);
    }

    protected void flushBuffer() throws IOException {
        if (this.pos > 0) {
            if (this.out == null) {
                if (this.pos == this.posLimit) {
                    int n = this.buf.length;
                    this.buf = new byte[n * 2];
                    System.arraycopy(this.buf, 0, this.buf, 0, n);
                    this.posLimit = this.buf.length;
                }
                return;
            }
            this.out.write(this.buf, 0, this.pos);
            this.count += this.pos;
            this.pos = 0;
        }
    }

    public int getUnflushedCount() {
        return this.pos;
    }

    public void flush() throws IOException {
        this.flushBuffer();
        if (this.out != null) {
            this.out.flush();
        }
    }

    public void close() throws IOException {
        this.flush();
        if (this.out != null) {
            this.out.close();
        }
    }

    public boolean complete() throws IOException {
        boolean bl = false;
        if (!this.limited || this.limit == 0L) {
            bl = true;
        }
        return bl;
    }

    public FastOutputStream(OutputStream outputStream, int n) {
        this.out = outputStream;
        this.setBuffer(new byte[n]);
    }

    public FastOutputStream(OutputStream outputStream, byte[] byArray) {
        this.out = outputStream;
        this.setBuffer(byArray);
    }

    public FastOutputStream(int n) {
        this.setBuffer(new byte[n]);
    }

    public FastOutputStream(byte[] byArray) {
        this.setBuffer(byArray);
    }
}

