/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.hme.io;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class FastInputStream
extends FilterInputStream {
    int pos;
    int count;
    byte[] buf;
    char[] str;
    long limit;
    long total;
    boolean marked;

    public long getCount() {
        return this.total - (long)this.count + (long)this.pos;
    }

    public void setLimit(long l) throws IOException {
        this.total = this.count - this.pos;
        this.limit = l;
        if (l >= 0L && this.total > l) {
            throw new IOException("limit already exceeded: " + this.total + " > " + l);
        }
    }

    public boolean isDrained() throws IOException {
        if (this.limit == (long)-1) {
            boolean bl = false;
            if (this.pos == this.count) {
                bl = true;
            }
            return bl;
        }
        boolean bl = false;
        if (this.limit == this.total) {
            bl = true;
        }
        return bl;
    }

    protected int fillBuffer(byte[] byArray, int n, int n2) throws IOException {
        return this.in.read(byArray, n, n2);
    }

    public boolean fill() throws IOException {
        int n;
        if (this.in == null) {
            return false;
        }
        int n2 = this.count - this.pos;
        if (n2 == this.buf.length) {
            return false;
        }
        if (this.marked && this.count == this.buf.length) {
            this.marked = false;
        }
        if (!this.marked) {
            if (n2 > 0) {
                System.arraycopy(this.buf, this.pos, this.buf, 0, n2);
            }
            this.count = n2;
            this.pos = 0;
        }
        int n3 = this.buf.length - this.count;
        if (this.limit >= 0L && (long)n3 > this.limit - this.total) {
            n3 = (int)(this.limit - this.total);
        }
        if ((n = this.fillBuffer(this.buf, this.count, n3)) > 0) {
            this.count += n;
            this.total += (long)n;
            return true;
        }
        return false;
    }

    public void unread(int n) throws IOException {
        if (this.pos == 0) {
            throw new IOException("unable to unread");
        }
        this.buf[--this.pos] = (byte)n;
    }

    public int read() throws IOException {
        return this.pos < this.count || this.fill() ? this.buf[this.pos++] & 0xFF : -1;
    }

    public int readOne() throws IOException {
        int n = this.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.pos == this.count && !this.fill()) {
            return -1;
        }
        if (n2 > this.count - this.pos) {
            n2 = this.count - this.pos;
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.pos += n2;
        return n2;
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = this.read(byArray, n, n2);
            if (n3 < 0) {
                throw new EOFException("could not read " + n2 + " bytes");
            }
            n += n3;
            n2 -= n3;
        }
    }

    public void skip(int n) throws IOException {
        while (n > 0) {
            if (this.pos == this.count && !this.fill()) {
                throw new EOFException();
            }
            int n2 = n;
            if (n2 > this.count - this.pos) {
                n2 = this.count - this.pos;
            }
            this.pos += n2;
            n -= n2;
        }
    }

    public String readLine() throws IOException {
        int n = 0;
        if (this.str == null) {
            this.str = new char[256];
        }
        block5: while (true) {
            int n2 = this.read();
            switch (n2) {
                case -1: {
                    if (n > 0) break block5;
                    return null;
                }
                case 10: {
                    break block5;
                }
                case 13: {
                    n2 = this.read();
                    if (n2 == 10) break block5;
                    this.unread(n2);
                    break block5;
                }
                default: {
                    if (n == this.str.length) {
                        char[] cArray = new char[this.str.length * 2];
                        System.arraycopy(this.str, 0, cArray, 0, n);
                        this.str = cArray;
                    }
                    this.str[n++] = (char)n2;
                    continue block5;
                }
            }
            break;
        }
        String string = new String(this.str, 0, n);
        return string;
    }

    public short readShort() throws IOException {
        return (short)((this.readOne() << 8) + this.readOne());
    }

    public int readInt() throws IOException {
        return (this.readOne() << 24) + (this.readOne() << 16) + (this.readOne() << 8) + this.readOne();
    }

    public long readVInt() throws IOException {
        long l;
        long l2 = 0L;
        int n = 0;
        while (((l = (long)this.read()) & 0x80L) == 0L) {
            l2 += l << n;
            if ((n += 7) <= 70) continue;
            throw new IOException("vint is too long");
        }
        if (l == (long)-1) {
            throw new EOFException();
        }
        l2 += (l & 0x3FL) << n;
        if ((l & 0x40L) != 0L) {
            l2 = -l2;
        }
        return l2;
    }

    public long readUnsignedInteger() throws IOException {
        int n;
        long l = 0L;
        int n2 = 0;
        while (((n = this.read()) & 0x80) == 0) {
            l += (long)(n << n2);
            n2 += 7;
        }
        if (n == -1) {
            throw new EOFException();
        }
        return l + (long)((n & 0x7F) << n2);
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + (long)this.readInt();
    }

    public short readLittleShort() throws IOException {
        return (short)(this.readOne() + (this.readOne() << 8));
    }

    public int readLittleInt() throws IOException {
        return this.readOne() + (this.readOne() << 8) + (this.readOne() << 16) + (this.readOne() << 24);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readUTF() throws IOException {
        int n = this.readShort();
        StringBuffer stringBuffer = new StringBuffer(n);
        byte[] byArray = new byte[n];
        int n2 = 0;
        this.readFully(byArray, 0, n);
        while (n2 < n) {
            int n3 = byArray[n2] & 0xFF;
            switch (n3 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++n2;
                    stringBuffer.append((char)n3);
                    break;
                }
                case 12: 
                case 13: {
                    if ((n2 += 2) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0x1F) << 6 | by & 0x3F));
                    break;
                }
                case 14: {
                    if ((n2 += 3) > n) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 - 2];
                    byte by2 = byArray[n2 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuffer.append((char)((n3 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F));
                    break;
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return new String(stringBuffer);
    }

    public int available() throws IOException {
        int n = this.count - this.pos;
        if (this.in != null) {
            n += this.in.available();
        }
        return n;
    }

    public synchronized void mark(int n) {
        if (n > this.buf.length) {
            throw new IllegalArgumentException("readlimit is too long");
        }
        int n2 = this.count - this.pos;
        if (n2 > 0) {
            System.arraycopy(this.buf, this.pos, this.buf, 0, n2);
        }
        this.count = n2;
        this.pos = 0;
        this.marked = true;
    }

    public synchronized void reset() throws IOException {
        if (!this.marked) {
            throw new IOException("mark invalidated - cannont reset");
        }
        this.pos = 0;
        this.marked = false;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.in = null;
        }
        if (this.limit > 0L && this.total < this.limit) {
            throw new IOException("limit not reached, " + (this.limit - this.total) + " bytes remain");
        }
    }

    public FastInputStream(InputStream inputStream, int n) {
        super(inputStream);
        if (inputStream == null) {
            throw new NullPointerException("Null stream");
        }
        this.buf = new byte[n];
        this.limit = -1;
    }

    public FastInputStream(byte[] byArray, int n, int n2) {
        super(null);
        this.buf = byArray;
        this.pos = n;
        this.count = this.pos + n2;
    }
}

