/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.hme.io;

import com.tivo.hme.io.FastInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedInputStream
extends FastInputStream {
    boolean terminator;
    int clen;

    public int read() throws IOException {
        if (!this.startChunk()) {
            return -1;
        }
        int n = super.read();
        if (n >= 0) {
            --this.clen;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.startChunk()) {
            return -1;
        }
        int n3 = super.read(byArray, n, Math.min(n2, this.clen));
        if (n3 > 0) {
            this.clen -= n3;
        }
        return n3;
    }

    public void readTerminator() throws IOException {
        while (this.startChunk()) {
            this.skip(this.clen);
        }
        this.terminator = false;
    }

    public void skip(int n) throws IOException {
        while (n > 0) {
            if (!this.startChunk()) {
                throw new EOFException("can't skip terminator");
            }
            int n2 = Math.min(n, this.clen);
            super.skip(n2);
            n -= n2;
            this.clen -= n2;
        }
    }

    private final boolean startChunk() throws IOException {
        if (this.clen == 0 && !this.terminator) {
            int n;
            int n2 = super.read();
            if ((n2 | (n = super.read())) < 0) {
                throw new EOFException("eof while reading chunk length");
            }
            this.clen = (n2 << 8) + n;
            if (this.clen == 0) {
                this.terminator = true;
            }
        }
        return this.terminator ^ true;
    }

    public ChunkedInputStream(InputStream inputStream, int n) {
        super(inputStream, n);
    }
}

