/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.hme.http.share;

import com.tivo.hme.io.FastOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HttpChunkedOutputStream
extends FastOutputStream {
    static final int CHUNK_TRAILER_SIZE = 2;
    boolean closed;
    boolean chunksEnabled;
    int chunkHeaderSize;

    public void reset() throws IOException {
        this.closed = false;
        this.chunksEnabled = false;
    }

    public void enableChunks() throws IOException {
        if (!this.chunksEnabled) {
            this.flush();
            this.chunksEnabled = true;
            this.pos = this.chunkHeaderSize = Integer.toHexString(this.buf.length).length() + 2;
            this.posLimit = this.buf.length - 2;
        }
    }

    public void disableChunks() throws IOException {
        if (this.chunksEnabled) {
            this.flush();
            this.chunksEnabled = false;
            this.pos = 0;
            this.posLimit = this.buf.length;
        }
    }

    public boolean chunksEnabled() {
        return this.chunksEnabled;
    }

    public void flushBuffer() throws IOException {
        if (!this.chunksEnabled) {
            super.flushBuffer();
            return;
        }
        int n = this.pos - this.chunkHeaderSize;
        if (n == 0) {
            return;
        }
        String string = Long.toHexString(n);
        int n2 = this.chunkHeaderSize;
        this.buf[--n2] = 10;
        this.buf[--n2] = 13;
        int n3 = string.length();
        while (--n3 >= 0) {
            this.buf[--n2] = (byte)string.charAt(n3);
        }
        this.buf[this.pos] = 13;
        this.buf[this.pos + 1] = 10;
        this.out.write(this.buf, n2, this.pos + 2 - n2);
        this.pos = this.chunkHeaderSize;
    }

    public void close() throws IOException {
        if (!this.closed) {
            if (this.chunksEnabled) {
                this.finish();
            } else {
                this.flush();
            }
            this.closed = true;
        }
    }

    public void finish() throws IOException {
        this.flush();
        this.buf[0] = 48;
        this.buf[1] = 13;
        this.buf[2] = 10;
        this.buf[3] = 13;
        this.buf[4] = 10;
        this.out.write(this.buf, 0, 5);
    }

    public HttpChunkedOutputStream(OutputStream outputStream, int n) {
        super(outputStream, n);
    }
}

