/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.hme.http.share;

import com.tivo.hme.http.share.Headers;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HttpChunkedInputStream
extends FilterInputStream {
    boolean eof;
    long clen;
    Headers footer;

    public int read() throws IOException {
        throw new IOException("not supported");
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.clen == 0L) {
            if (this.eof) {
                return -1;
            }
            this.readChunkSize();
            if (this.clen == 0L) {
                this.readFooter();
                this.eof = true;
                return -1;
            }
        }
        if ((long)n2 > this.clen) {
            n2 = (int)this.clen;
        }
        if ((n3 = this.in.read(byArray, n, n2)) > 0) {
            this.clen -= (long)n3;
            if (this.clen == 0L) {
                this.expect(13);
                this.expect(10);
            }
            return n3;
        }
        return n3;
    }

    private final void expect(int n) throws IOException {
        int n2 = this.in.read();
        if (n2 != n) {
            throw new IOException("invalid chunk: " + (char)n + " unexpected");
        }
    }

    private final void readChunkSize() throws IOException {
        int n;
        long l = -1;
        block8: while (true) {
            int n2;
            n = this.in.read();
            switch (n) {
                case -1: {
                    throw new EOFException("bad chunk");
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    n2 = n - 48;
                    break;
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    n2 = 10 + (n - 97);
                    break;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    n2 = 10 + (n - 65);
                    break;
                }
                case 9: 
                case 32: 
                case 59: {
                    while ((n = this.in.read()) != -1) {
                        if (n == 13) break;
                    }
                }
                case 13: {
                    break block8;
                }
                default: {
                    throw new IOException("malformed chunk: " + (char)n + " unexpected");
                }
            }
            if (l == (long)-1) {
                l = n2;
                continue;
            }
            l = (l << 4) + (long)n2;
        }
        if (n == -1) {
            throw new EOFException("malformed chunk");
        }
        if (n == 13) {
            this.expect(10);
        }
        this.clen = l;
    }

    private final void readFooter() throws IOException {
        this.footer = new Headers(this.in);
    }

    public int available() throws IOException {
        return (int)Math.min(Integer.MIN_VALUE, this.clen);
    }

    public Headers getFooter() {
        return this.footer;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        try {
            int n;
            HttpChunkedInputStream httpChunkedInputStream = new HttpChunkedInputStream(fileInputStream);
            byte[] byArray = new byte[1024];
            while ((n = httpChunkedInputStream.read(byArray, 0, byArray.length)) > 0) {
                System.out.write(byArray, 0, n);
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            fileInputStream.close();
            throw throwable;
        }
        {
            Object var3_7 = null;
        }
        fileInputStream.close();
    }

    public HttpChunkedInputStream(InputStream inputStream) {
        super(inputStream);
    }
}

