/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.hme.http.share;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class Headers {
    Hashtable hash = new Hashtable();
    List list = new ArrayList();
    char[] data;

    public void parse(InputStream inputStream) throws IOException {
        String string;
        this.data = new char[128];
        while ((string = this.readKey(inputStream)) != null) {
            String string2 = this.readValue(inputStream);
            this.hash.put(string.toLowerCase(), string2);
            this.list.add(string);
        }
        this.data = null;
    }

    public void addInternal(String string, String string2) {
        this.hash.put(string, string2);
    }

    private final String readKey(InputStream inputStream) throws IOException {
        int n = 0;
        while (true) {
            int n2 = inputStream.read();
            switch (n2) {
                case -1: {
                    throw new EOFException("bad mime header reading key: " + new String(this.data, 0, n));
                }
                case 58: {
                    return new String(this.data, 0, n);
                }
                case 13: {
                    n2 = inputStream.read();
                    if (n2 == 10) {
                        return null;
                    }
                    throw new IOException("malformed mime header: CRLF");
                }
                case 10: {
                    return null;
                }
            }
            if (n == this.data.length) {
                this.data = new char[n * 2];
                System.arraycopy(this.data, 0, this.data, 0, n);
            }
            this.data[n++] = (char)n2;
        }
    }

    private final String readValue(InputStream inputStream) throws IOException {
        int n = 0;
        block6: while (true) {
            int n2 = inputStream.read();
            switch (n2) {
                case -1: {
                    throw new EOFException("malformed mime header reading value");
                }
                case 13: {
                    n2 = inputStream.read();
                    if (n2 != 10) {
                        throw new IOException("Malformed mime header: CRLF");
                    }
                }
                case 10: {
                    return new String(this.data, 0, n).trim();
                }
                case 9: 
                case 32: {
                    if (n == 0) continue block6;
                }
                default: {
                    if (n == this.data.length) {
                        this.data = new char[n * 2];
                        System.arraycopy(this.data, 0, this.data, 0, n);
                    }
                    this.data[n++] = (char)n2;
                }
            }
        }
    }

    public String get(String string) {
        String string2 = (String)this.hash.get(string);
        if (string2 == null) {
            string2 = (String)this.hash.get(string.toLowerCase());
        }
        return string2;
    }

    public int getInt(String string, int n) {
        String string2 = this.get(string);
        return string2 == null ? n : Integer.parseInt(string2);
    }

    public long getLong(String string, long l) {
        String string2 = this.get(string);
        return string2 == null ? l : Long.parseLong(string2);
    }

    public Iterator getKeys() {
        return this.list.iterator();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.getKeys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.get(string);
            stringBuffer.append(string);
            stringBuffer.append(": ");
            stringBuffer.append(string2);
            stringBuffer.append("\r\n");
        }
        return new String(stringBuffer);
    }

    public Headers(InputStream inputStream) throws IOException {
        this.parse(inputStream);
    }
}

