/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.hme.http.server;

import com.tivo.hme.http.server.HttpConnection;
import com.tivo.hme.http.server.HttpRequest;
import com.tivo.hme.http.share.IHttpConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public abstract class HttpServer
implements IHttpConstants {
    protected String name;
    protected String host;
    protected int port;
    protected InetAddress intf;
    Listener listener;
    ServerSocket ss;

    public InetAddress getInterface() {
        return this.intf;
    }

    public int getPort() {
        return this.port;
    }

    public String getServerURL() {
        return "http://" + this.host + ':' + this.port + '/';
    }

    public void start() throws IOException {
        this.listener = new Listener();
    }

    public void stop() {
        this.close();
    }

    public void handleAccept(Socket socket) throws IOException {
        new Thread(new HttpConnection(this, socket)).start();
    }

    public void handle(HttpRequest httpRequest) throws IOException {
    }

    public boolean handleContinue(HttpRequest httpRequest) throws IOException {
        return true;
    }

    protected void handleException(HttpRequest httpRequest, Throwable throwable) {
        System.out.println("HttpServer.handleException : " + throwable);
    }

    void close() {
        this.listener = null;
        ServerSocket serverSocket = this.ss;
        if (serverSocket != null) {
            this.ss = null;
            try {
                if (serverSocket != null) {
                    serverSocket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        TestServer testServer = new TestServer(Integer.parseInt(stringArray[0]));
        if (stringArray.length > 1) {
            testServer.useChunked = true;
        }
        testServer.start();
    }

    public HttpServer(String string, int n) throws IOException {
        this(string, null, null, n);
    }

    public HttpServer(String string, String string2, InetAddress inetAddress, int n) throws IOException {
        this.name = string;
        this.host = string2;
        this.port = n;
        this.intf = inetAddress;
        if (inetAddress == null) {
            this.intf = inetAddress = InetAddress.getLocalHost();
        }
        if (string2 == null) {
            this.host = string2 = inetAddress.getHostName();
        }
        if (string == null) {
            this.name = "HttpServer";
        }
        this.ss = new ServerSocket(n, 50, inetAddress);
        if (n == 0) {
            this.port = this.ss.getLocalPort();
        }
    }

    class Listener
    extends Thread {
        public void interrupt() {
            HttpServer.this.close();
            super.interrupt();
        }

        public void run() {
            block3: {
                try {
                    while (HttpServer.this.ss != null) {
                        HttpServer.this.handleAccept(HttpServer.this.ss.accept());
                    }
                }
                catch (IOException iOException) {
                    if (HttpServer.this.ss == null) break block3;
                    iOException.printStackTrace();
                    HttpServer.this.close();
                }
            }
        }

        Listener() throws IOException {
            super(HttpServer.this.name + '(' + HttpServer.this.intf.getHostAddress() + ':' + HttpServer.this.port + ')');
            this.start();
        }
    }

    static class TestServer
    extends HttpServer {
        File dir = new File(new File(".").getCanonicalPath());
        boolean useChunked;

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handle(HttpRequest httpRequest) throws IOException {
            httpRequest.reply(200, "OK");
            String string = httpRequest.getURI();
            FileInputStream fileInputStream = new FileInputStream(new File(this.dir, string));
            try {
                OutputStream outputStream;
                if (this.useChunked) {
                    if (!httpRequest.enableChunkedEncoding()) {
                        System.out.println("FAILED TO TURN ON CHUNKED");
                    }
                    outputStream = httpRequest.getOutputStream();
                } else {
                    outputStream = httpRequest.getOutputStream(fileInputStream.available());
                }
                byte[] byArray = new byte[1024];
                while (true) {
                    int n;
                    block7: {
                        if ((n = fileInputStream.read(byArray, 0, byArray.length)) > 0) break block7;
                        outputStream.flush();
                        break;
                    }
                    outputStream.write(byArray, 0, n);
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                fileInputStream.close();
                throw throwable;
            }
            {
                Object var5_9 = null;
            }
            fileInputStream.close();
        }

        TestServer(int n) throws IOException {
            super("TEST", n);
            System.out.println("USING: " + this.dir);
        }
    }
}

