/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.hme.http.server;

import com.tivo.hme.http.server.HttpConnection;
import com.tivo.hme.http.server.HttpServer;
import com.tivo.hme.http.server.IHttpRequest;
import com.tivo.hme.http.share.Headers;
import com.tivo.hme.http.share.HttpChunkedInputStream;
import com.tivo.hme.http.share.HttpChunkedOutputStream;
import com.tivo.hme.http.share.HttpException;
import com.tivo.hme.io.FastInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;

public class HttpRequest
implements IHttpRequest {
    HttpConnection conn;
    InputStream in;
    HttpChunkedOutputStream out;
    String method;
    String uri;
    Headers headers;
    int httpVersion;
    boolean chunkedEnabled;
    boolean keep;
    boolean replied;

    static HttpRequest read(HttpConnection httpConnection, boolean bl) throws IOException {
        FastInputStream fastInputStream = httpConnection.in;
        String string = fastInputStream.readLine();
        if (string == null) {
            return null;
        }
        if (string.length() == 0 && bl && (string = fastInputStream.readLine()) == null) {
            return null;
        }
        return new HttpRequest(httpConnection, string);
    }

    public HttpConnection getConnection() {
        return this.conn;
    }

    public InetAddress getInetAddress() {
        return this.conn.s.getInetAddress();
    }

    public HttpServer getServer() {
        return this.conn.server;
    }

    private final boolean requestHasPayload() {
        boolean bl = false;
        if (this.method.equals("POST") || this.method.equals("PUT")) {
            bl = true;
        }
        return bl;
    }

    public String get(String string) {
        return this.headers.get(string);
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public String getMethod() {
        return this.method;
    }

    public String getURI() {
        return this.uri;
    }

    public int getVersion() {
        return this.httpVersion;
    }

    public long getContentLength() {
        String string = this.get("content-length");
        return string != null ? Long.parseLong(string) : (long)-1;
    }

    public String getContentType() {
        String string = this.get("content-type");
        if (string == null) {
            return "unknown";
        }
        int n = string.indexOf(59);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string.trim().toLowerCase();
    }

    public boolean getReplied() {
        return this.replied;
    }

    public String getContentEncoding() {
        int n;
        String string = this.get("content-type");
        if (string != null && (n = string.indexOf("charset=")) >= 0) {
            if ((n = (string = string.substring(n + 8)).indexOf(59)) >= 0) {
                string = string.substring(0, n);
            }
            if (string.startsWith("\"") && string.endsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            }
            return string.trim().toLowerCase();
        }
        return "ascii";
    }

    public InputStream getInputStream() throws IOException {
        if (this.in != null) {
            return this.in;
        }
        if (!this.requestHasPayload()) {
            return null;
        }
        String string = this.get("content-length");
        if (string != null) {
            this.in = this.conn.in;
            this.conn.in.setLimit(Long.parseLong(string));
        } else if ("chunked".equals("transfer-encoding")) {
            this.in = new HttpChunkedInputStream(this.conn.in);
        }
        return this.in;
    }

    public void reply(int n, String string) throws IOException {
        if (this.replied) {
            throw new HttpException("invalid request state");
        }
        this.replied = true;
        if (this.keep && this.in == this.conn.in) {
            this.keep = this.conn.in.isDrained();
            if (!this.keep) {
                System.out.println("DISABLED KEEP: input not drained");
            }
        }
        this.conn.getOutputStream();
        this.conn.out.print(this.get("http-version") + ' ' + n + ' ' + string + "\r\n");
        this.conn.out.print("Server: " + this.conn.server.name + "\r\n");
    }

    public void addHeader(String string, String string2) throws IOException {
        if (this.conn.out == null) {
            throw new IOException("Must reply before adding headers");
        }
        this.conn.out.print(string);
        this.conn.out.print(": ");
        this.conn.out.print(string2);
        this.conn.out.print("\r\n");
    }

    public boolean enableChunkedEncoding() {
        if (this.httpVersion >= 11) {
            this.chunkedEnabled = true;
        }
        return this.chunkedEnabled;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getOutputStream(-1);
    }

    public OutputStream getOutputStream(long l) throws IOException {
        if (this.out != null) {
            return this.out;
        }
        this.out = this.conn.out;
        if (l >= 0L) {
            this.addHeader("Content-length", Long.toString(l));
            if (this.httpVersion == 10) {
                this.addHeader("Connection", "Keep-Alive");
            }
            this.conn.out.print("\r\n");
            this.conn.out.setLimit(l);
        } else if (this.httpVersion >= 11) {
            if (this.chunkedEnabled) {
                this.addHeader("Transfer-Encoding", "chunked");
                this.conn.out.print("\r\n");
                this.conn.out.enableChunks();
            } else {
                this.keep = false;
                this.addHeader("Connection", "close");
                this.conn.out.print("\r\n");
            }
        } else {
            this.keep = false;
            this.conn.out.print("\r\n");
        }
        return this.out;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        if (this.conn == null) return;
        try {
            if (!this.replied) {
                this.reply(500, "Internal Server Error: no handler for request");
            }
            if (this.out == null) {
                this.chunkedEnabled = false;
                this.getOutputStream(-1);
            }
            this.out.close();
            if (!this.out.chunksEnabled() && this.keep) {
                this.keep = this.conn.out.complete();
            }
            if (!this.keep) {
                this.conn.close();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.conn = null;
            throw throwable;
        }
        {
            Object var2_3 = null;
            this.conn = null;
            return;
        }
    }

    public String toString() {
        return "HttpRequest " + this.uri;
    }

    private HttpRequest(HttpConnection httpConnection, String string) throws IOException {
        this.conn = httpConnection;
        FastInputStream fastInputStream = httpConnection.in;
        int n = string.indexOf(32);
        if (n < 0) {
            throw new HttpException("malformed HTTP request: " + string);
        }
        int n2 = string.indexOf(32, n + 1);
        if (n2 < 0) {
            throw new HttpException("malformed HTTP request: " + string);
        }
        this.method = string.substring(0, n);
        this.uri = string.substring(n + 1, n2);
        String string2 = string.substring(n2 + 1);
        this.httpVersion = string2.endsWith("/1.0") ? 10 : 11;
        this.headers = new Headers(fastInputStream);
        this.headers.addInternal("http-method", this.method);
        this.headers.addInternal("http-uri", this.uri);
        this.headers.addInternal("http-version", string2);
        String string3 = this.headers.get("connection");
        switch (this.httpVersion) {
            case 10: {
                if (!"Keep-Alive".equalsIgnoreCase(string3)) break;
                boolean bl = false;
                if (!this.requestHasPayload() || this.getContentLength() >= 0L) {
                    bl = true;
                }
                this.keep = bl;
                break;
            }
            default: {
                this.keep = "close".equals(string3) ^ true;
            }
        }
    }
}

