/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.hme.http.client;

import com.tivo.hme.http.share.Headers;
import com.tivo.hme.http.share.HttpChunkedInputStream;
import com.tivo.hme.http.share.HttpException;
import com.tivo.hme.http.share.IHttpConstants;
import com.tivo.hme.io.FastInputStream;
import com.tivo.hme.io.FastOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.util.Iterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HttpClient
implements IHttpConstants {
    String method;
    URL url;
    String userAgent;
    int httpVersion;
    Socket socket;
    InputStream in;
    FastOutputStream out;
    boolean requestComplete;
    int status;
    Headers headers;
    boolean chunksDisabled;

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public int getVersion() {
        return this.httpVersion;
    }

    public String getMethod() {
        return this.method;
    }

    public URL getURL() {
        return this.url;
    }

    public void connect() throws IOException {
        if (this.socket != null) {
            throw new HttpException("invalid HttpClient state (already connected)");
        }
        int n = this.url.getPort();
        if (n == -1) {
            n = 80;
        }
        this.socket = new Socket(this.url.getHost(), n);
        this.out = new FastOutputStream(this.socket.getOutputStream(), 4380);
        String string = this.url.getFile();
        if (string.equals("")) {
            string = "/";
        }
        String string2 = "HTTP/" + (this.httpVersion == 10 ? "1.0" : "1.1");
        this.out.print(this.method + ' ' + string + ' ' + string2 + "\r\n");
        this.addHeader("Host", this.url.getHost());
        this.addHeader("User-Agent", this.userAgent);
        if (this.httpVersion >= 11) {
            this.addHeader("Connection", "close");
        }
    }

    public void addHeader(String string, String string2) throws IOException {
        if (this.out == null) {
            this.connect();
        }
        this.out.print(string + ": " + string2 + "\r\n");
    }

    public Socket getSocket() {
        return this.socket;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getOutputStream(-1);
    }

    public OutputStream getOutputStream(int n) throws IOException {
        if (this.out == null) {
            this.connect();
        }
        if (!this.requestComplete) {
            if (n >= 0) {
                this.out.setLimit(n);
                this.addHeader("Content-Length", Integer.toString(n));
            }
            this.out.print("\r\n");
            this.out.flush();
            this.requestComplete = true;
        }
        return this.out;
    }

    public InputStream getInputStream() throws IOException {
        if (this.in != null) {
            return this.in;
        }
        if (!this.requestComplete) {
            this.getOutputStream();
        }
        this.in = new FastInputStream(this.socket.getInputStream(), 4380);
        do {
            String string;
            if ((string = ((FastInputStream)this.in).readLine()) == null) {
                throw new HttpException("unexpected EOF in HTTP response header");
            }
            int n = string.indexOf(32);
            if (n < 0) {
                throw new HttpException("malformed HTTP response: " + string);
            }
            int n2 = string.indexOf(32, n + 1);
            if (n2 < 0) {
                throw new HttpException("malformed HTTP response: " + string);
            }
            String string2 = string.substring(0, n);
            try {
                this.status = Integer.parseInt(string.substring(n + 1, n2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new HttpException("malformed HTTP status code '" + string + '\'');
            }
            String string3 = string.substring(n2 + 1);
            if (this.headers == null) {
                this.headers = new Headers(this.in);
            } else {
                this.headers.parse(this.in);
            }
            this.headers.addInternal("http-version", string2);
            this.headers.addInternal("http-status", Integer.toString(this.status));
            this.headers.addInternal("http-statustext", string3);
        } while (this.status == 100);
        if (this.httpVersion >= 11 && this.isChunkedResponse()) {
            this.in = new HttpChunkedInputStream(this.in);
        }
        return this.in;
    }

    boolean isChunkedResponse() throws IOException {
        boolean bl = false;
        if (!this.chunksDisabled && "chunked".equals(this.get("transfer-encoding"))) {
            bl = true;
        }
        return bl;
    }

    public int getStatus() throws IOException {
        if (this.headers == null) {
            this.getInputStream();
        }
        return this.status;
    }

    public String get(String string) throws IOException {
        return this.getHeaders().get(string);
    }

    public Headers getHeaders() throws IOException {
        if (this.headers == null) {
            this.getInputStream();
        }
        return this.headers;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drain() throws IOException {
        InputStream inputStream = this.getInputStream();
        try {
            byte[] byArray = new byte[1024];
            while (inputStream.read(byArray, 0, byArray.length) > 0) {
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            inputStream.close();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        inputStream.close();
    }

    public void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.in == null) {
                try {
                    this.drain();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.out == null) {
                try {
                    this.getOutputStream(-1).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.socket = null;
        }
    }

    public void setChunksDisabled(boolean bl) {
        this.chunksDisabled = bl;
    }

    public static void main(String[] stringArray) throws IOException {
        int n;
        Object object;
        boolean bl = false;
        if (stringArray.length == 0) {
            System.out.println("Usage: HttpClient [URL]");
            System.exit(1);
        } else if (stringArray.length > 1 && stringArray[1].equals("-debug")) {
            bl = true;
        }
        HttpClient httpClient = new HttpClient(new URL(stringArray[0]));
        httpClient.setChunksDisabled(bl);
        httpClient.connect();
        httpClient.addHeader("Connection", "close");
        httpClient.getOutputStream();
        InputStream inputStream = httpClient.getInputStream();
        System.out.println(httpClient.getMethod() + ' ' + httpClient.getURL());
        Iterator iterator = httpClient.getHeaders().getKeys();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            String string = httpClient.get((String)object);
            System.out.println((String)object + ": " + string);
        }
        System.out.println();
        object = new byte[1024];
        while ((n = inputStream.read((byte[])object, 0, ((Object)object).length)) > 0) {
            System.out.write((byte[])object, 0, n);
        }
        httpClient.close();
    }

    private final /* synthetic */ void this() {
        this.chunksDisabled = false;
    }

    public HttpClient(URL uRL) {
        this("GET", uRL);
    }

    public HttpClient(String string, URL uRL) {
        this(string, uRL, 11);
    }

    public HttpClient(String string, URL uRL, int n) {
        this.this();
        this.method = string;
        this.url = uRL;
        this.httpVersion = n;
        this.userAgent = "tivo.http/03/30/2003";
        this.requestComplete = false;
    }
}

