/*
 * Decompiled with CFR 0.152.
 */
package com.mutchek.vonaje;

import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.WebTable;
import com.mutchek.vonaje.Click2CallException;
import com.mutchek.vonaje.InvalidPhoneNumberException;
import com.mutchek.vonaje.Message;
import com.mutchek.vonaje.PhoneNumber;
import com.mutchek.vonaje.VonageAccount;
import com.mutchek.vonaje.VonageConnectivityException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;

public class VonagePhoneNumber {
    private String messageCache = null;
    private PhoneNumber number = null;
    private VonageAccount account;
    private ArrayList messages;
    private int inPlanMinutesUsed = 0;
    private int inPlanMinutesRemaining = 0;
    private int regionalMinutesUsed = 0;
    private int freeInNetworkMinutesUsed = 0;
    private int freeInAccountMinutesUsed = 0;
    private int freeMinutesUsed = 0;
    private boolean doneBilling = false;
    private boolean doneActivity = false;

    public VonagePhoneNumber(VonageAccount vonageAccount, String string) throws InvalidPhoneNumberException {
        this.number = new PhoneNumber(string);
        this.account = vonageAccount;
    }

    public void setMessageCache(String string) {
        this.messageCache = string;
        if (!this.messageCache.endsWith(File.separator)) {
            this.messageCache = this.messageCache + File.separator;
        }
    }

    public String getMessageCache() {
        return this.messageCache;
    }

    public VonageAccount getVonageAccount() {
        return this.account;
    }

    public void initiateCall(PhoneNumber phoneNumber) throws Click2CallException {
        String string = "";
        try {
            URL uRL = new URL(VonageAccount.VONAGE_REST_MAKE_CALL);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setDoOutput(true);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
            outputStreamWriter.write("username=" + URLEncoder.encode(this.account.getUsername(), "UTF-8") + "&password=" + URLEncoder.encode(this.account.getPassword(), "UTF-8") + "&fromnumber=" + URLEncoder.encode(this.number.getNumber(), "UTF-8") + "&tonumber=" + URLEncoder.encode(phoneNumber.getNumber(), "UTF-8"));
            ((Writer)outputStreamWriter).close();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            string = bufferedReader.readLine();
        }
        catch (MalformedURLException malformedURLException) {
            throw new Click2CallException(malformedURLException.getMessage());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Click2CallException(unsupportedEncodingException.getMessage());
        }
        catch (IOException iOException) {
            throw new Click2CallException(iOException.getMessage());
        }
        if (!string.substring(0, 2).equals("000")) {
            throw new Click2CallException(string);
        }
    }

    public void initiateCall(String string) throws Click2CallException {
        try {
            PhoneNumber phoneNumber = new PhoneNumber(string);
            this.initiateCall(phoneNumber);
        }
        catch (Exception exception) {
            throw new Click2CallException();
        }
    }

    public String getNumber() {
        return this.number.getNumber();
    }

    public String toString() {
        return this.number.getNumber();
    }

    public boolean hasMessageList() {
        return this.messages != null;
    }

    public ArrayList getMessageList() throws VonageConnectivityException {
        if (this.messages == null) {
            WebConversation webConversation = this.account.getVonageSession();
            this.messages = new ArrayList();
            try {
                WebResponse webResponse = webConversation.getResponse(this.account.getVonageWebVoicemail());
                WebTable webTable = webResponse.getTableStartingWith("New");
                for (int i = 1; i < webTable.getRowCount(); ++i) {
                    Message message = new Message();
                    message.setVonagePhoneNumber(this);
                    WebLink[] webLinkArray = webTable.getTableCell(i, 0).getLinks();
                    if (webLinkArray.length > 0) {
                        message.markNew(true);
                    } else {
                        message.markNew(false);
                    }
                    try {
                        message.setCallerNumber(webTable.getCellAsText(i, 1));
                    }
                    catch (InvalidPhoneNumberException invalidPhoneNumberException) {
                        System.err.println(invalidPhoneNumberException.getMessage());
                    }
                    String string = webTable.getTableCell(i, 4).getLinkWith("Listen").getURLString();
                    Pattern pattern = Pattern.compile("msgID=(\\d+)");
                    Matcher matcher = pattern.matcher(string);
                    matcher.find();
                    message.setListID(Integer.parseInt(matcher.group(1)));
                    message.setCallTime(webTable.getCellAsText(i, 2));
                    message.setDuration(webTable.getCellAsText(i, 3));
                    message.setURL(this.account.getVonageWeb() + webTable.getTableCell(i, 4).getLinkWith("Listen").getURLString());
                    message.applyCallerID();
                    this.messages.add(message);
                }
            }
            catch (SAXException sAXException) {
                throw new VonageConnectivityException();
            }
            catch (IOException iOException) {
                throw new VonageConnectivityException();
            }
        }
        return this.messages;
    }

    public boolean deleteMessageIndex(int n) throws VonageConnectivityException {
        int n2 = ((Message)this.messages.get(n)).getListID();
        return this.deleteMessage(n2);
    }

    public boolean deleteMessage(int n) throws VonageConnectivityException {
        boolean bl = false;
        String string = null;
        Message message = null;
        if (n < 1 || n > this.messages.size()) {
            bl = false;
        } else {
            Message message2;
            Iterator iterator = this.messages.iterator();
            while (iterator.hasNext()) {
                message2 = (Message)iterator.next();
                if (message2.getListID() == n) {
                    string = this.account.getVonageWebVoicemail() + "?did=" + this.number.getNumber() + "&msgIDList=" + n + "&folder=Inbox" + "&action=handleDeleteMessages";
                    message = message2;
                    continue;
                }
                if (message2.getListID() <= n) continue;
                message2.setListID(message2.getListID() - 1);
            }
            if (string != null) {
                message.removeFromCache();
                this.messages.remove(message);
                this.messages.trimToSize();
                message2 = this.account.getVonageSession();
                try {
                    WebResponse webResponse = message2.getResponse(string);
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                }
            }
            bl = true;
        }
        return bl;
    }

    private void retrieveBillingScreenInfo() throws VonageConnectivityException {
        if (!this.doneBilling) {
            this.doneBilling = true;
            WebConversation webConversation = this.account.getVonageSession();
            try {
                WebResponse webResponse = webConversation.getResponse(this.account.getVonageWebBilling());
                WebTable webTable = webResponse.getTableStartingWith("In-Plan Minutes used:");
                String string = "";
                string = webTable.getCellAsText(0, 1);
                if (string.matches("^[0-9]+$")) {
                    this.inPlanMinutesUsed = Integer.parseInt(string);
                }
                if ((string = webTable.getCellAsText(1, 1)).matches("^[0-9]+$")) {
                    this.inPlanMinutesRemaining = Integer.parseInt(string);
                }
                if ((string = webTable.getCellAsText(2, 1)).matches("^[0-9]+$")) {
                    this.regionalMinutesUsed = Integer.parseInt(string);
                }
                if ((string = webTable.getCellAsText(3, 1)).matches("^[0-9]+$")) {
                    this.freeInNetworkMinutesUsed = Integer.parseInt(string);
                }
                if ((string = webTable.getCellAsText(4, 1)).matches("^[0-9]+$")) {
                    this.freeInAccountMinutesUsed = Integer.parseInt(string);
                }
                if ((string = webTable.getCellAsText(5, 1)).matches("^[0-9]+$")) {
                    this.freeMinutesUsed = Integer.parseInt(string);
                }
            }
            catch (SAXException sAXException) {
                throw new VonageConnectivityException();
            }
            catch (IOException iOException) {
                throw new VonageConnectivityException();
            }
        }
    }

    private void retrieveActivityScreenInfo() throws VonageConnectivityException {
        throw new VonageConnectivityException("NOT IMPLEMENTED");
    }

    public int getInPlanMinutesUsed() throws VonageConnectivityException {
        this.retrieveBillingScreenInfo();
        return this.inPlanMinutesUsed;
    }

    public int getInPlanMinutesRemaining() throws VonageConnectivityException {
        this.retrieveBillingScreenInfo();
        return this.inPlanMinutesRemaining;
    }

    public int getRegionalMinutesUsed() throws VonageConnectivityException {
        this.retrieveBillingScreenInfo();
        return this.regionalMinutesUsed;
    }

    public int getFreeInNetworkMinutesUsed() throws VonageConnectivityException {
        this.retrieveBillingScreenInfo();
        return this.freeInNetworkMinutesUsed;
    }

    public int getFreeInAccountMinutesUsed() throws VonageConnectivityException {
        this.retrieveBillingScreenInfo();
        return this.freeInAccountMinutesUsed;
    }

    public int getFreeMinutesUsed() throws VonageConnectivityException {
        this.retrieveBillingScreenInfo();
        return this.freeMinutesUsed;
    }
}

