/*
 * Decompiled with CFR 0.152.
 */
package com.mutchek.vonaje;

import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebResponse;
import com.mutchek.vonaje.InvalidPhoneNumberException;
import com.mutchek.vonaje.VonageConnectivityException;
import com.mutchek.vonaje.VonagePhoneNumber;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Properties;
import org.xml.sax.SAXException;

public class VonageAccount {
    public static String VONAGE_REST = "https://secure.click2callu.com/tpcc";
    public static String VONAGE_REST_GET_NUMBERS = VONAGE_REST + "/getnumbers";
    public static String VONAGE_REST_MAKE_CALL = VONAGE_REST + "/makecall";
    private String vonage_web = "";
    private String vonage_web_action = "";
    private Properties country;
    private String username;
    private String password;
    private String accountNumber;
    private ArrayList numbers;
    private WebConversation wwwVonageSession = null;

    public VonageAccount(String string, String string2) {
        this(string, string2, System.getProperty("vonaje.country"));
    }

    public VonageAccount(String string, String string2, String string3) {
        this.username = string;
        this.password = string2;
        if (string3 == null) {
            string3 = "us";
        }
        this.country = new Properties();
        try {
            this.country.load(this.getClass().getResourceAsStream("country/" + string3 + ".properties"));
            this.vonage_web = this.country.getProperty("vonage_web");
            this.vonage_web_action = this.country.getProperty("vonage_web_action");
        }
        catch (IOException iOException) {
            this.vonage_web = "https://secure.vonage.com";
            this.vonage_web_action = "/vonage-web/";
        }
    }

    protected WebConversation getVonageSession() throws VonageConnectivityException {
        if (this.wwwVonageSession == null) {
            this.wwwVonageSession = new WebConversation();
        }
        try {
            WebResponse webResponse = null;
            webResponse = this.wwwVonageSession.getResponse(this.getVonageWebDashboard());
            WebForm webForm = webResponse.getFormWithID("logonForm");
            if (webForm != null) {
                webForm.setParameter("username", this.username);
                webForm.setParameter("password", this.password);
                WebResponse webResponse2 = webForm.submit();
                webForm = webResponse2.getFormWithID("logonForm");
                if (webForm != null) {
                    throw new VonageConnectivityException("Login attempt denied.");
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new VonageConnectivityException(malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            throw new VonageConnectivityException("IO error.");
        }
        catch (SAXException sAXException) {
            throw new VonageConnectivityException("Unexpected response.");
        }
        return this.wwwVonageSession;
    }

    public ArrayList getPhoneNumbers() {
        if (this.numbers == null) {
            String[] stringArray;
            String string = "";
            try {
                stringArray = new URL(VONAGE_REST_GET_NUMBERS);
                URLConnection uRLConnection = stringArray.openConnection();
                uRLConnection.setDoOutput(true);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
                outputStreamWriter.write("username=" + URLEncoder.encode(this.username, "UTF-8") + "&password=" + URLEncoder.encode(this.password, "UTF-8"));
                ((Writer)outputStreamWriter).close();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                string = bufferedReader.readLine();
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            stringArray = string.split(",");
            this.numbers = new ArrayList(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    this.numbers.add(new VonagePhoneNumber(this, stringArray[i]));
                    continue;
                }
                catch (InvalidPhoneNumberException invalidPhoneNumberException) {
                    // empty catch block
                }
            }
        }
        return this.numbers;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getVonageWeb() {
        return this.vonage_web;
    }

    public String getVonageWebVoicemail() {
        return this.vonage_web + this.vonage_web_action + "features/voicemail/messages/view.htm";
    }

    public String getVonageWebDashboard() {
        return this.vonage_web + this.vonage_web_action + "dashboard/index.htm";
    }

    public String getVonageWebBilling() {
        return this.vonage_web + this.vonage_web_action + "billing/index.htm";
    }

    public String getVonageWebActivity() {
        return this.vonage_web + this.vonage_web_action + "activity/index.htm";
    }

    public Properties getCountryProperties() {
        return this.country;
    }
}

