/*
 * Decompiled with CFR 0.152.
 */
package com.mutchek.vonaje;

import com.mutchek.vonaje.InvalidPhoneNumberException;

public class PhoneNumber {
    private String thisNumber = "";

    public PhoneNumber(String string) throws InvalidPhoneNumberException {
        if (!PhoneNumber.isValidNumber(string)) {
            throw new InvalidPhoneNumberException();
        }
        this.thisNumber = string;
    }

    public String getNumber() {
        return this.thisNumber;
    }

    public String toString() {
        return this.thisNumber;
    }

    public String format() {
        return PhoneNumber.format(this.thisNumber);
    }

    public String formatWithoutParens() {
        return PhoneNumber.formatWithoutParens(this.thisNumber);
    }

    public static boolean isValidNumber(String string) {
        return string.matches("^[\\d]{11}$");
    }

    public boolean isValidNumber() {
        return this.thisNumber.matches("^[\\d]{11}$");
    }

    public static String format(String string) {
        return "(" + string.substring(1, 4) + ") " + string.substring(4, 7) + "-" + string.substring(7);
    }

    public static String formatWithoutParens(String string) {
        return string.substring(1, 4) + "-" + string.substring(4, 7) + "-" + string.substring(7);
    }
}

