/*
 * Decompiled with CFR 0.152.
 */
package com.mutchek.vonaje;

import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebResponse;
import com.mutchek.vonaje.InvalidPhoneNumberException;
import com.mutchek.vonaje.OrphanedMessageException;
import com.mutchek.vonaje.PhoneNumber;
import com.mutchek.vonaje.ProgressHandler;
import com.mutchek.vonaje.VonageConnectivityException;
import com.mutchek.vonaje.VonagePhoneNumber;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;

public class Message {
    private PhoneNumber callerNumber = null;
    private String callerName = "";
    private String callerAddress = "";
    private Date time = null;
    private int duration = 0;
    private String url = "";
    private boolean newFlag = false;
    private int originalSize = 0;
    private String cache = "";
    private VonagePhoneNumber vonagePhoneNumber = null;
    private int listID = 0;

    public void delete() throws VonageConnectivityException {
        this.vonagePhoneNumber.deleteMessage(this.listID);
    }

    public String getDateString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmma");
        return simpleDateFormat.format(this.time);
    }

    protected void setVonagePhoneNumber(VonagePhoneNumber vonagePhoneNumber) {
        this.vonagePhoneNumber = vonagePhoneNumber;
    }

    public VonagePhoneNumber getVonagePhoneNumber() {
        return this.vonagePhoneNumber;
    }

    public boolean isNew() {
        return this.newFlag;
    }

    protected void setListID(int n) {
        this.listID = n;
    }

    public int getListID() {
        return this.listID;
    }

    protected void markNew(boolean bl) {
        this.newFlag = bl;
    }

    public String getCallerNumber() {
        return this.callerNumber.getNumber();
    }

    public String getCallerName() {
        return this.callerName;
    }

    public Date getCallTime() {
        return this.time;
    }

    protected void setCallerNumber(String string) throws InvalidPhoneNumberException {
        this.callerNumber = new PhoneNumber(string);
    }

    public String getCallerAddress() {
        return this.callerAddress;
    }

    protected void applyCallerID() {
        if (this.callerNumber.isValidNumber()) {
            WebConversation webConversation = new WebConversation();
            try {
                WebResponse webResponse = webConversation.getResponse("http://www.google.com/search?q=" + this.callerNumber.getNumber().substring(1));
                String string = webResponse.getText();
                Pattern pattern = Pattern.compile("<font size=-1>(.*?),.*?,(.*?)<a");
                Matcher matcher = pattern.matcher(string);
                if (matcher.find()) {
                    this.callerName = matcher.group(1);
                    this.callerAddress = matcher.group(2).trim();
                }
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("Invalid or unknown number, skipping caller id.");
        }
    }

    protected void setCallTime(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.vonagePhoneNumber.getVonageAccount().getCountryProperties().getProperty("date_format"));
        try {
            this.time = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
    }

    protected void setDuration(int n) {
        this.duration = n;
    }

    protected void setDuration(String string) {
        String[] stringArray = string.split(":");
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        this.duration = n * 60 + n2;
    }

    public int getDuration() {
        return this.duration;
    }

    protected void setURL(String string) {
        this.url = string;
    }

    public String getURL() {
        return this.url;
    }

    public String getCallerString() {
        String string = "";
        string = this.callerName.equals("") ? this.callerNumber.format() : this.callerName + " (" + this.callerNumber.formatWithoutParens() + ")";
        return string;
    }

    public String toString() {
        return this.getCallerString();
    }

    public File getMessage(ProgressHandler progressHandler) throws OrphanedMessageException {
        WebConversation webConversation = null;
        if (this.vonagePhoneNumber == null) {
            throw new OrphanedMessageException();
        }
        try {
            webConversation = this.vonagePhoneNumber.getVonageAccount().getVonageSession();
        }
        catch (VonageConnectivityException vonageConnectivityException) {
            vonageConnectivityException.printStackTrace();
        }
        File file = null;
        File file2 = new File(this.vonagePhoneNumber.getMessageCache() + this.vonagePhoneNumber.getNumber());
        if (!file2.exists()) {
            file2.mkdir();
        }
        if (!(file = new File(this.vonagePhoneNumber.getMessageCache() + this.vonagePhoneNumber.getNumber() + File.separator + this.getDateString() + "_" + this.callerNumber.getNumber() + ".wav")).exists()) {
            try {
                int n;
                WebResponse webResponse = webConversation.getResponse(this.getURL());
                InputStream inputStream = webResponse.getInputStream();
                FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath());
                float f = this.duration * 15000;
                int n2 = 0;
                while ((n = inputStream.read()) >= 0) {
                    fileOutputStream.write(n);
                    if (++n2 % 16384 != 0) continue;
                    progressHandler.setProgress((float)n2 / f);
                }
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("MalformedURL");
                malformedURLException.printStackTrace();
            }
            catch (IOException iOException) {
                System.out.println("IOException");
                iOException.printStackTrace();
            }
            catch (SAXException sAXException) {
                System.out.println("SAXException");
                sAXException.printStackTrace();
            }
        }
        progressHandler.setComplete(true);
        this.markNew(false);
        return file;
    }

    public boolean isCached() {
        File file = null;
        file = new File(this.vonagePhoneNumber.getMessageCache() + this.vonagePhoneNumber.getNumber() + File.separator + this.getDateString() + "_" + this.callerNumber.getNumber() + ".wav");
        return file.exists();
    }

    public void removeFromCache() {
        File file = null;
        file = new File(this.vonagePhoneNumber.getMessageCache() + this.vonagePhoneNumber.getNumber() + File.separator + this.getDateString() + "_" + this.callerNumber.getNumber() + ".wav");
        if (file.exists()) {
            file.delete();
        }
    }
}

