/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.hme.bananas;

import com.tivo.hme.bananas.BApplication;
import com.tivo.hme.bananas.BPoint;
import com.tivo.hme.bananas.BRect;
import com.tivo.hme.bananas.BView;
import com.tivo.hme.bananas.IBananas;
import com.tivo.hme.sdk.IHmeProtocol;
import com.tivo.hme.sdk.Resource;
import java.util.Hashtable;

public class BSkin
implements IHmeProtocol,
IBananas {
    protected BApplication app;
    protected Hashtable map;

    public BSkin(BApplication bApplication) {
        this.app = bApplication;
        this.map = new Hashtable();
        new Element(this, "up", 20, 7);
        new Element(this, "down", 20, 7);
        new Element(this, "left", 8, 20);
        new Element(this, "right", 8, 20);
        Element element = new Element(this, "bar", 640, 48);
        element.set("cap", "30");
        element.set("padh", "10");
        element.set("padv", "4");
        new Element(this, "pageup", 14, 26);
        new Element(this, "pagedown", 14, 26);
    }

    public Element get(String string) {
        Element element = (Element)this.map.get(string);
        if (element == null) {
            throw new RuntimeException("unknown element : " + string);
        }
        if (element.rsrc == null) {
            element.rsrc = this.app.getResource("com/tivo/hme/bananas/" + element.name + ".png");
        }
        return element;
    }

    public BPoint getAnchor(String string, BRect bRect, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n > 1048575) {
            if ((n & 0xF00000) != 0) {
                n6 = n | 0xFFF00000;
                n = (n | 0x1000000) & 0xFF000000;
            } else {
                n6 = n & 0xFFFFF;
                n &= 0xFF000000;
            }
        } else {
            n6 = n;
            n = 0;
        }
        if (n2 > 1048575) {
            if ((n2 & 0xF00000) != 0) {
                n5 = n2 | 0xFFF00000;
                n2 = (n2 | 0x1000000) & 0xFF000000;
            } else {
                n5 = n2 & 0xFFFFF;
                n2 &= 0xFF000000;
            }
        } else {
            n5 = n2;
            n2 = 0;
        }
        Element element = this.get(string);
        switch (n) {
            case 0x3000000: {
                n4 = 0;
                break;
            }
            default: {
                n4 = (bRect.width - element.width) / 2;
                break;
            }
            case 0x5000000: {
                n4 = bRect.width - element.width;
            }
        }
        switch (n2) {
            case 0x3000000: {
                n3 = 0;
                break;
            }
            default: {
                n3 = (bRect.height - element.height) / 2;
                break;
            }
            case 0x5000000: {
                n3 = bRect.height - element.height;
            }
        }
        return new BPoint(n4 + n6, n3 + n5);
    }

    public BView createSkin(BView bView, String string, int n, int n2) {
        Element element = this.get(string);
        BView bView2 = new BView(bView, n, n2, element.width, element.height);
        bView2.setResource(element.rsrc);
        return bView2;
    }

    public BView createSkinStretch(BView bView, String string, int n, int n2, int n3) {
        Element element = this.get(string);
        HStretch hStretch = new HStretch(bView, element);
        hStretch.setBounds(n, n2, n3, element.height);
        return hStretch;
    }

    public static class Element {
        public String name;
        public int width;
        public int height;
        public Resource rsrc;
        public Hashtable properties;

        public Element(BSkin bSkin, String string, int n, int n2) {
            this.name = string.intern();
            this.width = n;
            this.height = n2;
            bSkin.map.put(string, this);
        }

        public void set(String string, String string2) {
            if (this.properties == null) {
                this.properties = new Hashtable();
            }
            this.properties.put(string, string2);
        }

        public String get(String string) {
            if (this.properties == null) {
                return null;
            }
            return (String)this.properties.get(string);
        }

        public int getInt(String string, int n) {
            String string2 = this.get(string);
            return string2 != null ? Integer.parseInt(string2) : n;
        }
    }

    static class HStretch
    extends BView {
        Element e;
        BView left;
        BView right;

        HStretch(BView bView, Element element) {
            super(bView, 0, 0, 0, 0);
            this.e = element;
            this.left = new BView(this, 0, 0, 0, 0);
            this.right = new BView(this, 0, 0, 0, 0);
            this.left.setResource(element.rsrc, 1);
            this.right.setResource(element.rsrc, 4);
        }

        public void setBounds(int n, int n2, int n3, int n4, Resource resource) {
            super.setBounds(n, n2, n3, n4, resource);
            int n5 = Math.min(n3, this.e.width) - this.e.getInt("cap", 30) & 0xFFFFFFFE;
            this.left.setBounds(0, 0, n5, this.e.height, resource);
            this.right.setBounds(n5, 0, n3 - n5, this.e.height, resource);
        }
    }
}

