/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.hme.bananas;

import com.tivo.hme.bananas.BHighlight;
import com.tivo.hme.bananas.BHighlights;
import com.tivo.hme.bananas.BRect;
import com.tivo.hme.bananas.BScreen;
import com.tivo.hme.bananas.BView;
import com.tivo.hme.bananas.IBananas;
import com.tivo.hme.bananas.IHighlightsLayout;
import com.tivo.hme.sdk.Resource;
import java.util.Enumeration;
import java.util.Vector;

public abstract class BList
extends BView {
    public static final String ANIM = "*100";
    protected Vector elements = new Vector();
    protected Vector rows = new Vector();
    protected int rowHeight;
    protected int nVisibleRows;
    protected BHighlights rowHighlights;
    protected int focused;
    protected int top;
    protected int dirty;
    boolean animate;

    public BList(BView bView, int n, int n2, int n3, int n4, int n5) {
        this(bView, n, n2, n3, n4, n5, true);
    }

    public BList(BView bView, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(bView, n, n2, n3, n4, bl);
        this.rowHeight = n5;
        this.nVisibleRows = n4 / n5;
        this.rowHighlights = new BHighlights(new Layout());
        this.clear();
    }

    public BHighlights getRowHighlights() {
        return this.rowHighlights;
    }

    public void setBarAndArrows(int n, int n2, Object object, Object object2) {
        this.getRowHighlights().setBarAndArrows(n, n2, object, object2, true);
    }

    protected abstract void createRow(BView var1, int var2);

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getFocus() {
        return this.focused;
    }

    public void setFocus(int n, boolean bl) {
        int n2 = this.size();
        if (n2 > 0) {
            this.animate = bl;
            this.focused = Math.min(Math.max(n, 0), n2 - 1);
            this.getScreen().setFocus(this.getRow(this.focused));
            this.animate = false;
        }
    }

    public void setTop(int n) {
        this.setTop(n, this.focused);
    }

    public void setTop(int n, int n2) {
        this.dirty = this.top;
        this.top = n;
        this.focused = Math.min(Math.max(n2, 0), this.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        BScreen bScreen = this.getScreen();
        Resource resource = this.animate ? this.getResource(ANIM) : null;
        this.animate = false;
        int n = this.size();
        bScreen.setPainting(false);
        try {
            IBananas iBananas;
            int n2;
            int n3;
            int n4;
            this.top = Math.max(Math.min(this.top, n - this.nVisibleRows), 0);
            int n5 = Math.min(this.top + this.nVisibleRows, n) - 1;
            if (this.focused < this.top) {
                this.top = Math.max(0, this.focused);
            } else if (this.focused > n5) {
                n4 = Math.min(this.focused + 1, n);
                this.top = Math.max(n4 - this.nVisibleRows, 0);
            }
            n4 = Math.max(this.top - this.nVisibleRows, 0);
            int n6 = Math.min(this.top + 2 * this.nVisibleRows, this.size());
            if (this.dirty < this.top) {
                n3 = Math.max(this.dirty - this.nVisibleRows, 0);
                n2 = n6;
            } else {
                n3 = n4;
                n2 = Math.min(this.dirty + 2 * this.nVisibleRows, this.size());
            }
            this.dirty = this.top;
            for (int i = n3; i < n2; ++i) {
                if (i < n4 || i >= n6) {
                    iBananas = (BView)this.rows.elementAt(i);
                    if (iBananas == null) continue;
                    iBananas.remove();
                    this.rows.setElementAt(null, i);
                    continue;
                }
                this.getRow(i);
            }
            this.setTranslation(0, -this.top * this.rowHeight, resource);
            BHighlights bHighlights = this.getHighlights();
            iBananas = bHighlights.get("pageup");
            BHighlight bHighlight = bHighlights.get("pagedown");
            if (iBananas != null && bHighlight != null) {
                ((BHighlight)iBananas).setVisible(this.top > 0 ? 1 : 2);
                bHighlight.setVisible(this.top + this.nVisibleRows < this.rows.size() ? 1 : 2);
                bHighlights.refresh(resource);
            }
            if (this.focused != -1) {
                bHighlights = this.getRowHighlights();
                BHighlight bHighlight2 = bHighlights.get("up");
                BHighlight bHighlight3 = bHighlights.get("down");
                if (bHighlight2 != null && bHighlight3 != null) {
                    bHighlight2.setVisible(this.focused > 0 ? 0 : 2);
                    bHighlight3.setVisible(this.focused < n - 1 ? 0 : 2);
                }
                this.rowHighlights.refresh(resource);
            } else if (this.isAncestorOf(bScreen.focus)) {
                if (n > 0) {
                    this.setFocus(0, false);
                } else {
                    bScreen.setFocus(bScreen.getFocusDefault());
                }
            }
        }
        finally {
            bScreen.setPainting(true);
        }
    }

    public boolean handleKeyPress(int n, long l) {
        int n2 = this.nVisibleRows - 1;
        int n3 = -1;
        int n4 = this.top;
        switch (n) {
            case 2: {
                n3 = this.focused - 1;
                break;
            }
            case 3: {
                n3 = this.focused + 1;
                break;
            }
            case 18: {
                n3 = this.top;
                n4 = this.top - n2;
                break;
            }
            case 19: {
                n4 = n3 = this.top + n2;
                break;
            }
            default: {
                return super.handleKeyPress(n, l);
            }
        }
        if (this.focused != -1) {
            int n5 = this.size() - 1;
            n3 = Math.max(Math.min(n3, n5), 0);
            if (n4 == this.top) {
                if (n3 < this.top) {
                    n4 = n3 - (n2 - 1);
                } else if (n3 > this.top + n2) {
                    n4 = n3 - 1;
                }
            }
            n4 = Math.max(Math.min(n4, n5 - n2), 0);
            if (n3 == this.focused && n4 == this.top) {
                return false;
            }
            this.getBApp().playSoundForKey(n, true, true);
            if (n4 != this.top) {
                this.animate = true;
                this.setTop(n4, n3);
                this.refresh();
            }
            this.setFocus(n3, true);
        }
        return true;
    }

    public boolean handleKeyRepeat(int n, long l) {
        switch (n) {
            case 2: 
            case 3: 
            case 18: 
            case 19: {
                return this.handleKeyPress(n, l);
            }
        }
        return super.handleKeyRepeat(n, l);
    }

    public boolean handleFocus(boolean bl, BView bView, BView bView2) {
        if (bl) {
            if (bView == this) {
                this.setFocus(0, false);
            } else {
                this.focused = bView.y / this.rowHeight;
                this.refresh();
            }
        } else if (bView.parent != this) {
            this.refresh();
        }
        return true;
    }

    public int size() {
        return this.elements.size();
    }

    public boolean contains(Object object) {
        return this.elements.contains(object);
    }

    public void add(Object object) {
        this.add(this.size(), object);
    }

    public void add(Object[] objectArray) {
        this.add(this.size(), objectArray);
    }

    public void add(Vector vector) {
        this.add(this.size(), vector);
    }

    public int indexOf(Object object) {
        return this.elements.indexOf(object);
    }

    public int lastIndexOf(Object object) {
        return this.elements.lastIndexOf(object);
    }

    public boolean remove(Object object) {
        int n = this.elements.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    public void clear() {
        Enumeration enumeration = this.rows.elements();
        while (enumeration.hasMoreElements()) {
            BView bView = (BView)enumeration.nextElement();
            if (bView == null) continue;
            bView.remove();
        }
        this.elements.clear();
        this.rows.clear();
        this.focused = -1;
        this.refresh();
    }

    public Object get(int n) {
        return this.elements.get(n);
    }

    public BView getRow(int n) {
        BView bView = (BView)this.rows.get(n);
        if (bView == null) {
            bView = new BView(this, 0, n * this.rowHeight, this.width, this.rowHeight);
            bView.setFocusable(true);
            bView.highlights = this.rowHighlights;
            this.createRow(bView, n);
            this.rows.set(n, bView);
        } else {
            bView.setLocation(0, n * this.rowHeight);
        }
        return bView;
    }

    public Object set(int n, Object object) {
        Object object2 = this.elements.set(n, object);
        BView bView = this.rows.set(n, null);
        if (bView != null) {
            bView.remove();
        }
        if (bView.hasFocus()) {
            this.getScreen().setFocus(this.getRow(n));
        }
        this.refresh();
        return object2;
    }

    public void add(int n, Object object) {
        this.elements.add(n, object);
        this.rows.add(n, null);
        this.touch(n, 1);
    }

    public void add(int n, Object[] objectArray) {
        int n2 = objectArray.length;
        while (n2-- > 0) {
            this.elements.add(n, objectArray[n2]);
            this.rows.add(n, null);
        }
        this.touch(n, objectArray.length);
    }

    public void add(int n, Vector vector) {
        int n2 = vector.size();
        while (n2-- > 0) {
            this.elements.add(n, vector.elementAt(n2));
            this.rows.add(n, null);
        }
        this.touch(n, vector.size());
    }

    public Object remove(int n) {
        Object e = this.elements.remove(n);
        BView bView = (BView)this.rows.remove(n);
        if (bView != null) {
            bView.remove();
        }
        this.touch(n, -1);
        return e;
    }

    void touch(int n, int n2) {
        if (n <= this.focused) {
            this.focused += n2;
        }
        if (n2 > 0) {
            if (n <= this.top) {
                this.setTop(this.top + n2);
            } else {
                this.dirty += n2;
            }
        } else if (n < this.top) {
            this.setTop(this.top + n2);
        }
        this.refresh();
    }

    class Layout
    implements IHighlightsLayout {
        Layout() {
        }

        public BScreen getScreen() {
            return BList.this.getScreen();
        }

        public BRect getHighlightBounds() {
            BView bView = this.getRow();
            if (bView != null) {
                return bView.getHighlightBounds();
            }
            return BList.this.toScreenBounds(new BRect(0, 0, BList.this.width, BList.this.rowHeight));
        }

        public boolean getHighlightIsVisible(int n) {
            BView bView = this.getRow();
            return bView != null ? bView.getHighlightIsVisible(n) : false;
        }

        protected BView getRow() {
            return BList.this.focused != -1 ? (BView)BList.this.rows.elementAt(BList.this.focused) : null;
        }
    }
}

