/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.hme.bananas;

import com.tivo.hme.bananas.BEvent;
import com.tivo.hme.bananas.BScreen;
import com.tivo.hme.bananas.BSkin;
import com.tivo.hme.bananas.BView;
import com.tivo.hme.bananas.IBananas;
import com.tivo.hme.sdk.Application;
import com.tivo.hme.sdk.HmeEvent;
import java.util.Vector;

public abstract class BApplication
extends Application
implements IBananas {
    public static final String SLIDE_ANIM = "*400,1";
    public static final String FADE_ANIM = "*1000,1";
    public BView normal;
    public BView below;
    public BView above;
    public BSkin skin;
    protected Vector stack;
    protected boolean soundPlayed;
    protected boolean screenChanged;

    protected void init(Application.Context context) {
        this.below = new BView(this.root);
        this.normal = new BView(this.root);
        this.above = new BView(this.root);
        this.stack = new Vector();
        this.skin = new BSkin(this);
    }

    public BScreen getCurrentScreen() {
        if (this.stack.size() > 0) {
            return ((StackFrame)this.stack.lastElement()).screen;
        }
        return null;
    }

    public int getStackDepth() {
        return this.stack.size();
    }

    public void setSkin(BSkin bSkin) {
        this.skin = bSkin;
    }

    protected void dispatchEvent(HmeEvent hmeEvent) {
        switch (hmeEvent.opcode) {
            case 4: {
                this.dispatchKeyEvent((HmeEvent.Key)hmeEvent);
                break;
            }
            default: {
                super.dispatchEvent(hmeEvent);
            }
        }
    }

    protected void dispatchKeyEvent(HmeEvent.Key key) {
        boolean bl;
        BScreen bScreen = this.getCurrentScreen();
        BView bView = bScreen.focus != null ? bScreen.focus : bScreen;
        this.soundPlayed = false;
        this.screenChanged = false;
        bView.postEvent((HmeEvent)key);
        if (this.soundPlayed || key.action == 3) {
            return;
        }
        if (this.screenChanged) {
            bl = true;
        } else {
            BView bView2 = bScreen.focus != null ? bScreen.focus : bScreen;
            bl = bView != bView2;
        }
        this.playSoundForKey(key.code, bl, !this.screenChanged);
    }

    public boolean handleEvent(HmeEvent hmeEvent) {
        switch (hmeEvent.opcode) {
            case 7200: {
                BEvent.Action action = (BEvent.Action)hmeEvent;
                return this.handleAction(action.view, action.action);
            }
        }
        return super.handleEvent(hmeEvent);
    }

    public boolean handleAction(BView bView, Object object) {
        return false;
    }

    public void push(BScreen bScreen, int n) {
        this.push(bScreen, n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(BScreen bScreen, int n, Object object) {
        this.root.setPainting(false);
        try {
            StackFrame stackFrame = null;
            if (this.stack.size() > 0) {
                stackFrame = (StackFrame)this.stack.lastElement();
                stackFrame.doExit();
            }
            StackFrame stackFrame2 = new StackFrame(bScreen, n);
            this.stack.addElement(stackFrame2);
            stackFrame2.doEnter(object, false);
            switch (n) {
                case 0: {
                    if (stackFrame != null) {
                        stackFrame.screen.setVisible(false);
                    }
                    bScreen.setLocation(-this.normal.tx, this.normal.ty);
                    bScreen.setTransparency(0.0f);
                    break;
                }
                case 2: {
                    if (stackFrame != null) {
                        stackFrame.screen.setTransparency(1.0f, this.getResource(FADE_ANIM));
                    }
                    bScreen.setLocation(-this.normal.tx, this.normal.ty);
                    bScreen.setTransparency(1.0f);
                    bScreen.setTransparency(0.0f, this.getResource(FADE_ANIM));
                    break;
                }
                case 1: {
                    bScreen.setLocation(-this.normal.tx + this.normal.width, this.normal.ty);
                    bScreen.setTransparency(0.0f);
                    this.normal.translate(-this.normal.width, 0, this.getResource(SLIDE_ANIM));
                }
            }
            bScreen.setVisible(true);
            this.screenChanged = true;
        }
        finally {
            this.root.setPainting(true);
        }
    }

    public void pop() {
        this.pop(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pop(Object object) {
        if (this.stack.size() <= 1) {
            return;
        }
        this.root.setPainting(false);
        try {
            StackFrame stackFrame = (StackFrame)this.stack.lastElement();
            stackFrame.doExit();
            this.stack.removeElementAt(this.stack.size() - 1);
            StackFrame stackFrame2 = (StackFrame)this.stack.lastElement();
            stackFrame2.doEnter(object, true);
            switch (stackFrame.transition) {
                case 0: {
                    stackFrame.screen.setVisible(false);
                    stackFrame2.screen.setVisible(true);
                    break;
                }
                case 2: {
                    stackFrame.screen.setTransparency(1.0f, this.getResource(FADE_ANIM));
                    stackFrame2.screen.setTransparency(0.0f, this.getResource(FADE_ANIM));
                    break;
                }
                case 1: {
                    stackFrame.screen.setVisible(false, this.getResource(SLIDE_ANIM));
                    this.normal.translate(this.normal.width, 0, this.getResource(SLIDE_ANIM));
                }
            }
            this.screenChanged = true;
        }
        finally {
            this.root.setPainting(true);
        }
    }

    public void playSoundForKey(int n, boolean bl, boolean bl2) {
        String string = null;
        if (bl) {
            switch (n) {
                case 2: {
                    string = "updown";
                    break;
                }
                case 3: {
                    string = "updown";
                    break;
                }
                case 6: {
                    string = "select";
                    break;
                }
                case 14: {
                    string = "thumbsup";
                    break;
                }
                case 15: {
                    string = "thumbsdown";
                    break;
                }
                case 18: {
                    string = "pageup";
                    break;
                }
                case 19: {
                    string = "pagedown";
                    break;
                }
                case 4: {
                    string = bl2 ? "updown" : "pageup";
                    break;
                }
                case 5: {
                    string = bl2 ? "updown" : "pagedown";
                }
            }
        } else {
            switch (n) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 14: 
                case 15: 
                case 18: 
                case 19: {
                    string = "bonk";
                }
            }
        }
        if (string != null) {
            this.play(string + ".snd");
        }
    }

    public void play(String string) {
        super.play(string);
        this.soundPlayed = true;
    }

    static class StackFrame {
        BScreen screen;
        int transition;

        StackFrame(BScreen bScreen, int n) {
            this.screen = bScreen;
            this.transition = n;
        }

        void doEnter(Object object, boolean bl) {
            this.screen.postEvent(new BEvent.ScreenEnter(this.screen, object, bl));
        }

        void doExit() {
            this.screen.postEvent(new BEvent.ScreenExit(this.screen));
        }
    }
}

