/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.snip;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class Snip
extends Task {
    private static final String SNIP_START_OPEN = "@@snip:";
    private static final String SNIP_START_CLOSE = "@@";
    private static final String SNIP_END = "@@endSnip@@";
    private static final String PROPERTY_PREFIX = "snip.";
    private ArrayList filesets = new ArrayList();
    StringBuffer buf = new StringBuffer();
    private boolean xmlSafe = false;

    public void addFileSet(FileSet fs) {
        this.filesets.add(fs);
    }

    private boolean endSnip(String s) {
        return s.indexOf(SNIP_END) >= 0;
    }

    public void setXmlsafe(boolean xmlSafe) {
        this.xmlSafe = xmlSafe;
    }

    private String startSnip(String s) {
        int end;
        String result = null;
        int start = 0;
        start = s.indexOf(SNIP_START_OPEN);
        if (start >= 0 && (end = s.indexOf(SNIP_START_CLOSE, start += SNIP_START_OPEN.length())) >= 0 && (result = s.substring(start, end).trim()).length() == 0) {
            result = null;
        }
        return result;
    }

    private void snipFile(File file) throws BuildException {
        boolean snipping = false;
        String propertyName = null;
        this.buf.setLength(0);
        try {
            LineNumberReader in = new LineNumberReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(file))));
            String s = in.readLine();
            while (s != null) {
                if (snipping) {
                    if (this.endSnip(s)) {
                        snipping = false;
                        this.getProject().setProperty(PROPERTY_PREFIX + propertyName, this.xmlSafe ? this.buf.toString().replaceAll("<", "&lt;").replaceAll(">", "&gt;") : this.buf.toString());
                        propertyName = null;
                        this.buf.setLength(0);
                    } else {
                        this.buf.append("\n");
                        this.buf.append(s);
                    }
                } else {
                    propertyName = this.startSnip(s);
                    if (propertyName != null) {
                        snipping = true;
                    }
                }
                s = in.readLine();
            }
        }
        catch (Throwable t) {
            throw new BuildException("Unable to read " + file.getAbsolutePath() + ": " + t.getMessage(), t);
        }
    }

    public void execute() throws BuildException {
        Iterator i = this.filesets.iterator();
        while (i.hasNext()) {
            FileSet fs = (FileSet)i.next();
            File dir = fs.getDir(this.getProject());
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] srcFiles = ds.getIncludedFiles();
            int idx = 0;
            while (idx < srcFiles.length) {
                this.snipFile(new File(dir, srcFiles[idx]));
                ++idx;
            }
        }
    }
}

